package hls.support.core.wechat.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.wechat.dto.NotificationContent;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.formbean.WxMessageBean;
import hls.support.core.wechat.mapper.NotificationTemplateMapper;
import hls.support.core.wechat.mapper.WechatEnterpriseAppMapper;
import hls.support.core.wechat.service.INotificationContentService;
import hls.support.core.wechat.service.IWechatMessageService;
import hls.support.core.wechat.utils.WechatNotificationUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import hls.support.core.wechat.dto.NotificationTemplate;
import hls.support.core.wechat.service.INotificationTemplateService;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

@Service
@Transactional(rollbackFor = Exception.class)
public class NotificationTemplateServiceImpl extends BaseServiceImpl<NotificationTemplate> implements INotificationTemplateService {

    @Autowired
    NotificationTemplateMapper notificationTemplateMapper;

    @Autowired
    IWechatMessageService wechatMessageService;

    @Autowired
    WechatEnterpriseAppMapper wechatEnterpriseAppMapper;

    @Autowired
    INotificationContentService notificationContentService;

    @Value("#{configProperties['domain']}")
    private String domain;

    @Override
    public ResponseData sendNotication(IRequest iRequest, Map map) {
        ResponseData responseData = new ResponseData(false);
        if (map.containsKey("templateCode")) {
            String templateCode = (String) map.get("templateCode");
            String openId = (String) map.get("openId");
            String userIds = (String) map.get("userIds");
            String partyIds = (String) map.get("partyIds");
            String tagIds = (String) map.get("tagIds");
            NotificationTemplate notificationTemplate = new NotificationTemplate();
            notificationTemplate.setTemplateCode(templateCode);
            List<NotificationTemplate> notificationTemplates = notificationTemplateMapper.select(notificationTemplate);
            if (CollectionUtils.isEmpty(notificationTemplates)) {
                return responseData;
            }
            String content = notificationTemplates.get(0).getContent();
            Long appId = notificationTemplates.get(0).getAppId();
            String templateTagIds = notificationTemplates.get(0).getTagIds();
            String templateKey = notificationTemplates.get(0).getTemplateKey();
            //生成消息
            String message = WechatNotificationUtil.initMessage(content, map);
            NotificationContent notificationContent = new NotificationContent();
            notificationContent.setContent(message);
            NotificationContent noticeContent = notificationContentService.insertSelective(iRequest, notificationContent);
            String url = domain + "weChat/wechat_notification_content.view?id=" + noticeContent.getId();
            if (StringUtils.isEmpty(message)) {
                responseData.setMessage("某些模板替换值未被传入或者传入的替换值为空，请检查模板和传入的替换值！");
                return responseData;
            }
            WxMessageBean messageBean = new WxMessageBean();
            WechatEnterpriseApp app = new WechatEnterpriseApp();
            app.setId(appId);
            Long accountId = wechatEnterpriseAppMapper.selectByPrimaryKey(app).getAccountId();

            messageBean.setMessageType("text");
            messageBean.setAppId(appId);
            messageBean.setText(message);
            if (StringUtils.isEmpty(tagIds)) {
                tagIds = templateTagIds;
            }
            messageBean.setOpenId(openId);
            messageBean.setAccountId(accountId);
            messageBean.setUserIds(userIds);
            messageBean.setPartyIds(partyIds);
            messageBean.setTagIds(tagIds);
            messageBean.setUrl(url);
            messageBean.setTemplateId(templateKey);
            return wechatMessageService.sendTemplateText(messageBean);

        } else {
            responseData.setMessage("参数未传完整");
            return responseData;
        }
    }

    @Override
    public List<NotificationTemplate> query(IRequest iRequest, NotificationTemplate notificationTemplate, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        return notificationTemplateMapper.query(notificationTemplate);
    }
}