package hls.support.core.wechat.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.wechat.dto.HlsWechatNoticeRecord;
import hls.support.core.wechat.mapper.HlsWechatNoticeRecordMapper;
import hls.support.core.wechat.service.IHlsWechatNoticeRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: Jeffery
 * Date: 2017/12/7
 * Time: 15:53
 * To change this template use File | Settings | File Templates.
 */
@Service
@Transactional
public class HlsWechatNoticeRecordServiceImpl extends BaseServiceImpl<HlsWechatNoticeRecord> implements IHlsWechatNoticeRecordService {

    @Autowired
    private HlsWechatNoticeRecordMapper hlsWechatNoticeRecordMapper;

    @Override
    public List<HlsWechatNoticeRecord> addNotice(IRequest request, HlsWechatNoticeRecord dto) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");//设置日期格式
        List<HlsWechatNoticeRecord> list = new ArrayList<>();
        dto.set__status("add");
        dto.setNoticeDatetime(new Date());/*df.format(new Date())*/
        list.add(dto);
        return batchUpdate(request, list);
    }
}
