package hls.support.core.wechat.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.hand.app.hms.service.impl.PureNetUtilImpl;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.mybatis.entity.Example;
import com.hand.hap.mybatis.util.StringUtil;
import com.hand.hap.system.service.ISysConfigService;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.formbean.HavonInfo;
import hls.support.core.wechat.mapper.WechatAccountMapper;
import hls.support.core.wechat.mapper.WechatEnterpriseAppMapper;
import hls.support.core.wechat.service.IHavonMediaService;
import hls.support.core.wechat.utils.WeChatUtils;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.mp.api.WxMpService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.CharsetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: yang
 * Date: 2018/1/16
 * Time: 17:52
 */
@Service
public class HavonMediaServiceImpl implements IHavonMediaService {
    private static final String ERROR_ACCOUNT_NOT_FOUND = "ERROR_ACCOUNT_NOT_FOUND";
    private static final String ERROR_CONTRACT_CODE_EMPTY = "ERROR_CONTRACT_CODE_EMPTY";
    private static final String ERROR_ACCOUNT_NOT_SPECIFIED = "ERROR_ACCOUNT_NOT_SPECIFIED";
    public static final String STATUS_OK = "OK";
    private static final String ERROR_MEDIA_DOWNLOAD_FAILED = "ERROR_MEDIA_DOWNLOAD_FAILED";
    private static final String ERROR_ACCOUNT_TYPE = "ERROR_ACCOUNT_TYPE";
    private static final String ERROR_MEDIA_NOT_DOWNLOAD = "ERROR_MEDIA_NOT_DOWNLOAD";
    private static final String ERROR_MEDIA_NOT_UPLOAD = "ERROR_MEDIA_NOT_UPLOAD";
    private static final String ERROR_QUERY_TIME_EMPTY = "ERROR_QUERY_TIME_EMPTY";
    private static final String RESULT_ERROR = "-1";

    @Autowired
    private WechatEnterpriseAppMapper appMapper;
    @Autowired
    private WechatAccountMapper accountMapper;

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Value("#{configProperties['http.proxy.port']}")
    private Integer proxyPort;

    @Value("#{configProperties['http.proxy.host']}")
    private String proxyHost;

    private CloseableHttpClient httpClient;
    @Autowired
    IHapInterfaceHeaderService headerService;
    @Autowired
    ISysConfigService sysConfigService;

    public HavonMediaServiceImpl() {
        // ensure e-sign SDK will be init only once
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60 * 1000).setSocketTimeout(15000).build();
        httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    @Override
    public JSONObject saveMedia2Business(HavonInfo havonInfo) {
        JSONObject json = new JSONObject();
        logger.debug("wechatCode:{}, mediaId:{},sysName:{},apiName:{}",
                havonInfo.getWechatCode(), havonInfo.getMediaId(),
                 havonInfo.getSysName(), havonInfo.getApiName());
        if (StringUtil.isNotEmpty(havonInfo.getWechatCode())) {
            Example example = new Example(WechatEnterpriseApp.class);
            Example.Criteria criteria = example.createCriteria();
            logger.debug("**********WechatCode:[" + havonInfo.getWechatCode() + "]**********");
            criteria.andEqualTo("wxCode", havonInfo.getWechatCode());
            List<WechatEnterpriseApp> wechatEnterpriseApps = appMapper.selectByExample(example);
            if (CollectionUtils.isEmpty(wechatEnterpriseApps)) {
                json.put("false",ERROR_ACCOUNT_TYPE);
               /* havonInfo.setSuccess("false");
                havonInfo.setMessage(ERROR_ACCOUNT_NOT_FOUND);*/
            } else if (wechatEnterpriseApps.size() > 1) {
                json.put("false",ERROR_ACCOUNT_TYPE);
               /* havonInfo.setSuccess("false");
                havonInfo.setMessage(ERROR_ACCOUNT_NOT_SPECIFIED);*/
            }
            WechatEnterpriseApp app = wechatEnterpriseApps.get(0);
            WechatAccount account = accountMapper.selectByPrimaryKey(app.getAccountId());
            if (account == null) {
                json.put("false",ERROR_ACCOUNT_TYPE);
               /* havonInfo.setSuccess("false");
                havonInfo.setMessage(ERROR_ACCOUNT_NOT_FOUND);*/
            }
            File download;

            if (account.getAccountType().equals(WechatAccount.CORP)) {
                WxCpService wxCpService = WeChatUtils.initWxCpService(app.getCorpId(), app.getSecret(), Integer.valueOf(app.getAgentId()), proxyHost, proxyPort);
                try {
                    download = wxCpService.getMediaService().download(havonInfo.getMediaId());
                    json = getHavon(download,havonInfo);
                    json.put("success","true");
                } catch (WxErrorException e) {
                    json.put("false",ERROR_ACCOUNT_TYPE);
                   /* havonInfo.setSuccess("false");
                    havonInfo.setMessage(ERROR_MEDIA_NOT_DOWNLOAD);*/
                }
            } else if (account.getAccountType().equals(WechatAccount.SERV) || account.getAccountType().equals(WechatAccount.SUBS)) {
                WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), proxyHost, proxyPort);
                try {
                    download = wxMpService.getMaterialService().mediaDownload(havonInfo.getMediaId());
                    json = getHavon(download,havonInfo);
                } catch (WxErrorException e) {
                    json.put("false",ERROR_ACCOUNT_TYPE);
                    /*havonInfo.setSuccess("false");
                    havonInfo.setMessage(ERROR_MEDIA_NOT_DOWNLOAD);*/
                }
            }else{
                json.put("false",ERROR_ACCOUNT_TYPE);
                /*havonInfo.setSuccess("false");
                havonInfo.setMessage(ERROR_ACCOUNT_TYPE);*/
            }

        }
        return json;
    }

    private JSONObject getHavon(File file, HavonInfo info) {
        //todo upload file
        String apiName = info.getApiName();
        String sysName = info.getSysName();
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
        logger.info("return hapInterfaceHeader:{}", hapInterfaceHeader);
        String iftUrl = hapInterfaceHeader.getIftUrl();
        String hanvonKey = sysConfigService.getConfigValue("HANVON.KEY");
        String newUrl = iftUrl.replace("YOURKEY", hanvonKey);
        if (hapInterfaceHeader == null) {
            logger.debug("headerAndLineDTO is null， apiName:{}, sysName:{}", apiName, sysName);
            return null;
        }
        JSONObject json = new JSONObject();
        String filePath = "";
        filePath = file.getPath();
        try {
            String imageStr = PureNetUtilImpl.GetBase64(filePath);
            String uid = InetAddress.getLocalHost().getHostAddress();
            String inboundParam = "";
            inboundParam = "{\"uid\":\"" + uid + "\" ,\"image\":\"" + imageStr + "\"}";
            String url = hapInterfaceHeader.getDomainUrl() + newUrl;
            json = post(inboundParam, url);
        }catch (Exception e) {
            logger.info(e.toString());
            json.put("error", e.getMessage());
        }

        return json;
    }
    public JSONObject post(String body, String https_url) {
        String resultData = "";
        String charset = "UTF-8";
        try {
            URL myURL = new URL(https_url);
            HttpURLConnection connection = (HttpURLConnection) myURL.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            if (!body.isEmpty()) {
                connection.setDoOutput(true);
            }
            connection.setRequestProperty("Content-Type", "application/octet-stream");
            charset = "UTF-8";
            connection.connect();
            if (!body.isEmpty()) {
                OutputStream outputStream = connection.getOutputStream();
                outputStream.write(body.getBytes(charset));
                outputStream.flush();
                outputStream.close();
            }
            if (connection.getResponseCode() != 200) {
                throw new RuntimeException("HTTP GET Request Failed with Error code : " + connection.getResponseCode());
            }

            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
            StringBuilder results = new StringBuilder();
            String line;
            while ((line = reader.readLine()) != null) {
                results.append(line);
            }
            reader.close();
            connection.disconnect();
            resultData = results.toString();
        } catch (MalformedURLException e) {
            e.printStackTrace();
            logger.info("MalformedURLException", e.getMessage());

        } catch (IOException e) {
            e.printStackTrace();
            logger.info("IOException", e.getMessage());
        }
        //System.out.println(resultData);
        resultData = resultData.toString().replaceAll("null", "\"\"");

        return JSONObject.parseObject(resultData);
    }
}
