package hls.support.core.wechat.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.wechat.mapper.AutoRecoverMapper;
import me.chanjar.weixin.mp.api.WxMpMessageRouter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import hls.support.core.wechat.dto.AutoRecover;
import hls.support.core.wechat.service.IAutoRecoverService;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional(rollbackFor = Exception.class)
public class AutoRecoverServiceImpl extends BaseServiceImpl<AutoRecover> implements IAutoRecoverService {

    @Autowired
    AutoRecoverMapper mapper;

    @Override
    public List<AutoRecover> selectSeq(IRequest requestContext, AutoRecover dto, int page, int pagesize) {
        PageHelper.startPage(page, pagesize);
        return mapper.selectSeq(dto);
    }

    @Override
    public List<AutoRecover> queryAll() {
        return mapper.queryAll();
    }
}