package hls.support.core.wechat.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.wechat.dto.WechatDepartment;
import hls.support.core.wechat.mapper.WechatDepartmentMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import hls.support.core.wechat.dto.EnterpriseAppDepartment;
import hls.support.core.wechat.service.IAppDepartmentService;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional(rollbackFor = Exception.class)
public class AppDepartmentServiceImpl extends BaseServiceImpl<EnterpriseAppDepartment> implements IAppDepartmentService {

    @Autowired
    private WechatDepartmentMapper wechatDepartmentMapper;
    /**
     * 根据app查询可见部门列表
     */
    @Override
    public List<WechatDepartment> queryByApp(IRequest iRequest, WechatDepartment wechatDepartment, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        return wechatDepartmentMapper.queryByApp(wechatDepartment);
    }

}