package hls.support.core.wechat.service;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.ProxySelf;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.IBaseService;
import hls.support.core.wechat.dto.WechatMember;
import hls.support.core.wechat.dto.WechatTag;

import java.util.List;

public interface IWechatTagService extends IBaseService<WechatTag>, ProxySelf<IWechatTagService> {

    List<WechatTag> queryTag(IRequest requestContext, WechatTag dto, int page, int pageSize);

    /*批量操作标签*/
    Boolean batchUpdateTag(IRequest requestContext, List<WechatTag> tags);

    /*添加标签*/
    Boolean addTag(IRequest iRequest, WechatTag dto);

    /*更新标签*/
    Boolean updateTag(IRequest iRequest, WechatTag dto);

    /*删除标签*/
    Boolean deleteTag(IRequest iRequest, WechatTag dto);

    /*同步标签*/
    ResponseData refreshTag(IRequest reusetContext, Long accountId);

    /*在标签中添加用户*/
    boolean addTagUsers(IRequest requestContext, WechatTag dto);

    /*从标签中移除用户*/
    boolean removeTagUsers(IRequest requestContext, WechatTag tag);
}