package hls.support.core.wechat.service;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.formbean.WxMessageBean;
import hls.support.core.wechat.formbean.TemplateMessage;
import net.sf.json.JSONObject;
import org.springframework.web.multipart.MultipartFile;

/**
 * Created by weck on 06/01/2018 10:19 AM
 */
public interface IWechatMessageService {
    ResponseData sendMPNews(IRequest irequest, WxMessageBean messageBean);

    JSONObject uploadThumbPicture(IRequest requestCtx, MultipartFile image, Long accountId);

    ResponseData sendText(IRequest requestContext, WxMessageBean messageBean);

    ResponseData sendImage(IRequest requestContext, WxMessageBean messageBean);

    String uploadPicture(IRequest requestCtx, MultipartFile image);

    Integer judgeType(Long accountId, Long appId, String wxCode);

    ResponseData sendKefuMessage(IRequest requestCtx, WxMessageBean messageBean);

    /**
     * 发送模版消息
     */
    ResponseData sendTemplateMsg(IRequest requestCtx, TemplateMessage templateMessage);

    /**
     * 添加模版
     */
    ResponseData addTemplate(IRequest requestCtx, TemplateMessage templateMessage);

    /**
     * 设置行业
     */
    ResponseData setIndustry(IRequest requestCtx, TemplateMessage templateMessage);

    /**
     * 获取设置的行业
     */
    ResponseData getIndustry(IRequest requestCtx, TemplateMessage templateMessage);

    /**
     * 删除模板
     */
    ResponseData delTemplate(IRequest requestCtx, TemplateMessage templateMessage);

    /**
     * 获取所有模板
     */
    ResponseData getAllTemplate(IRequest requestCtx, TemplateMessage templateMessage);

    ResponseData sendTemplateText(WxMessageBean messageBean);
}
