package hls.support.core.wechat.service;


import com.hand.hap.core.IRequest;
import com.hand.hap.core.ProxySelf;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.IBaseService;
import hls.support.core.wechat.dto.WechatMenu;

import java.util.List;

public interface IWechatMenuService extends IBaseService<WechatMenu> , ProxySelf<IWechatTagService> {

    /**
     * 新增菜单，只更新数据库
     *
     * @param requestCtx requestContext
     * @param menuBean   菜单信息实体
     * @return 成功返回true，失败返回false加失败信息
     */
    ResponseData addMenu(IRequest requestCtx, WechatMenu menuBean);

    /**
     * 更新菜单，只更新数据库
     *
     * @param requestCtx requestContext
     * @param menuBean   菜单信息实体
     * @return 成功返回true，失败返回false加失败信息
     */
    ResponseData updateMenu(IRequest requestCtx, List<WechatMenu> menuBean);

    /**
     * 删除菜单，只更新数据库
     *
     * @param requestCtx requestContext
     * @param dto        菜单信息实体，含有要删除的菜单id
     * @return 成功返回true，失败返回false加失败信息
     */
    ResponseData deleteMenu(IRequest requestCtx, WechatMenu dto);

    /**
     * 查询菜单
     *
     * @param requestCtx requestContext
     * @param dto        菜单信息实体，含有查询所需要的应用id
     * @return 成功返回一个嵌套json对象，失败返回false加失败信息
     */
    ResponseData queryMenu(IRequest requestCtx, WechatMenu dto);

    /**
     * 同步微信后台的菜单数据
     * <p>
     * 根据应用id获取到微信号的corpid和secret之类的信息，调用微信后台接口取得远程菜单数据，更新到数据库中
     *
     * @param requestCtx requestContext
     * @param dto        菜单信息实体，含有同步所需要的应用id
     * @return 成功返回true，失败返回false和失败信息
     */
    ResponseData synchronizeMenu(IRequest requestCtx, WechatMenu dto);

    /**
     * 将数据库的菜单数据发布到微信后台，根据应用id查询数据库中的菜单数据，并调用微信接口创建菜单
     *
     * @param requestCtx requestContext
     * @param dto        菜单信息实体，含有应用id
     * @return 成功返回true，失败返回false和失败信息
     */
    ResponseData publishMenu(IRequest requestCtx, WechatMenu dto);

    ResponseData pushMenus(Long accountId);
}
