package hls.support.core.wechat.service;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.ProxySelf;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.IBaseService;
import hls.support.core.wechat.dto.WechatMember;
import hls.support.core.wechat.formbean.UserTag;

import java.util.List;
import java.util.Map;

public interface IWechatMemberService extends IBaseService<WechatMember>, ProxySelf<IWechatMemberService> {
    List<WechatMember> queryMemberByDepart(IRequest iRequest, WechatMember wechatMember, int page, int pageSize);

    List<WechatMember> queryMemberByTag(IRequest iRequest, WechatMember wechatMember, int page, int pageSize);

    List<WechatMember> queryMemberDetail(IRequest requestContext, WechatMember wechatMember, int page, int pageSize);

    boolean batchUpdateMember(IRequest requestCtx, List<WechatMember> dto);

    boolean addMember(IRequest requestCtx, WechatMember member);

    boolean updateMember(IRequest requestCtx, WechatMember member);

    boolean deleteMember(IRequest requestCtx, WechatMember member);

    ResponseData batchUpdateUserTag(IRequest requestCtx, UserTag userTag);
}