package hls.support.core.wechat.service;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.ProxySelf;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.IBaseService;
import hls.support.core.wechat.dto.WechatDepartment;

import java.util.List;

public interface IWechatDepartmentService extends IBaseService<WechatDepartment>, ProxySelf<IWechatDepartmentService> {

    /*查询通讯里*/
    List<WechatDepartment> queryDepartment(IRequest iRequest, WechatDepartment wechatDepartment, int page, int pageSize);

    /*新增部门*/
    ResponseData addDepartment(IRequest iRequest, WechatDepartment wechatDepartment);

    /*更新部门*/
    ResponseData updateDepartment(IRequest iRequest, WechatDepartment wechatDepartment);

    /*更新部门*/
    ResponseData deleteDepartment(IRequest iRequest, WechatDepartment wechatDepartment);

    /*修改部门*/
    ResponseData batchUpdateDepartment(IRequest iRequest, List<WechatDepartment> wechatDepartments);

    /*同步部门信息*/
    ResponseData refresh(IRequest reusetContext, Long accountId);

    List<WechatDepartment> treeListDeapartmentQuery(IRequest iRequest, WechatDepartment wechatDepartment);

}