package hls.support.core.wechat.dto;

import com.hand.hap.mybatis.annotation.ExtensionAttribute;
import com.hand.hap.system.dto.BaseDTO;

import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

@Table(name = "wechat_menu")
@ExtensionAttribute(disable = true)

public class WechatMenu extends BaseDTO {

    @Id
    @GeneratedValue
    private Long id;

    /*微信公众号或者应用id*/
    private Long wechatAccountId;

    /*父菜单的id*/
    private Long parentMenuId;

    /*菜单名称*/
    private String name;

    /*菜单内容类型*/
    private String type;

    /*菜单按钮对应的key*/
    private String menuKey;

    /*菜单按钮对应的url*/
    private String url;

    /*菜单序号*/
    private Long seq;

    /*菜单的state标识*/
    private Integer state;

    /*是否发布*/
    private String isPublished;

    /*重定向uri*/
    private String redirectUri;

    /*微信权限认证域*/
    private String scope;

    @Transient
    private List<WechatMenu> childMenus;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }


    public Long getWechatAccountId() {
        return wechatAccountId;
    }

    public void setWechatAccountId(Long wechatAccountId) {
        this.wechatAccountId = wechatAccountId;
    }


    public Long getParentMenuId() {
        return parentMenuId;
    }

    public void setParentMenuId(Long parentMenuId) {
        this.parentMenuId = parentMenuId;
    }


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }


    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }


    public String getMenuKey() {
        return menuKey;
    }

    public void setMenuKey(String menuKey) {
        this.menuKey = menuKey;
    }


    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }


    public Long getSeq() {
        return seq;
    }

    public void setSeq(Long seq) {
        this.seq = seq;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getIsPublished() {
        return isPublished;
    }

    public void setIsPublished(String isPublished) {
        this.isPublished = isPublished;
    }

    public List<WechatMenu> getChildMenus() {
        return childMenus;
    }

    public void setChildMenus(List<WechatMenu> childMenus) {
        this.childMenus = childMenus;
    }

    public String getRedirectUri() {
        return redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getScope() {

        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}
