package hls.support.core.wechat.dto;

/**
 * Created by weck on 26/12/2017 11:06 AM
 */

import javax.persistence.GeneratedValue;
import javax.persistence.Id;

import com.hand.hap.mybatis.annotation.ExtensionAttribute;
import org.hibernate.validator.constraints.Length;

import javax.persistence.Table;

import com.hand.hap.system.dto.BaseDTO;

import javax.persistence.Transient;
import javax.validation.constraints.NotNull;

@ExtensionAttribute(disable = true)
@Table(name = "wechat_department")
public class WechatDepartment extends BaseDTO {

    public static final String FIELD_ID = "id";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_PARENTID = "parentId";
    public static final String FIELD_ORDER = "order";
    public static final String FIELD_WEHCATID = "wechatId";


    @Id
    @GeneratedValue
    private Long id;//id

    private Integer departmentId; //部门id

    @Length(max = 255)
    @NotNull
    private String departmentName; //部门名称

    private Integer parentId; //父级部门id

    @NotNull
    private Long accountId; //企业号id

    private Long departmentOrder; //在父部门中的次序值


    @Transient
    private String parentName;//父级部门名称

    @Transient
    private Long appId; //企业应用id

    @Transient
    private Long isActive; //发送消息时是否可选

    @Transient
    private String weId;//该对象在微信服务器中的id

    @Transient
    private String name;//部门或成员名称


    @Transient
    private Integer type;// 1 部门 2 成员

    @Transient
    private String departmentIds;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getWeId() {
        return weId;
    }

    public void setWeId(String weId) {
        this.weId = weId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getParentId() {
        return parentId;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Integer getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Integer departmentId) {
        this.departmentId = departmentId;
    }

    public Long getDepartmentOrder() {
        return departmentOrder;
    }

    public void setDepartmentOrder(Long departmentOrder) {
        this.departmentOrder = departmentOrder;
    }

    public String getDepartmentIds() {
        return departmentIds;
    }

    public void setDepartmentIds(String departmentIds) {
        this.departmentIds = departmentIds;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getIsActive() {
        return isActive;
    }

    public void setIsActive(Long isActive) {
        this.isActive = isActive;
    }
}
