package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import hls.support.core.wechat.service.IWechatUserInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * Created by weck on 18/01/2018 6:01 PM
 */
@Controller
@RequestMapping(value = {"/r/api", "/"})
public class WechatUserInfoController extends BaseController {

    @Autowired
    private IWechatUserInfoService service;

    @RequestMapping("/wechat/user/get")
    @ResponseBody
    public Map<String, Object> getUser(@RequestParam(value = "code") String code, @RequestParam("wxCode") String wxCode, HttpServletRequest request) {
        IRequest requestCtx = createRequestContext(request);
        return service.getUserInfo(code, wxCode, requestCtx);
    }


    @RequestMapping("/wechat/userId/openId")
    @ResponseBody
    public Map<String, Object> getOpenId(@RequestParam(value = "userId") String userId, @RequestParam("wxCode") String wxCode, HttpServletRequest request) {
        IRequest requestCtx = createRequestContext(request);
        return service.converToOpenId(userId, wxCode, requestCtx);
    }


    @RequestMapping("/wechat/openId/userId")
    @ResponseBody
    public Map<String, Object> getUserId(@RequestParam(value = "openId") String openId, @RequestParam("wxCode") String wxCode, HttpServletRequest request) {
        IRequest requestCtx = createRequestContext(request);
        return service.converToUserId(openId, wxCode, requestCtx);
    }

    @RequestMapping("/wechat/user/getInfo")
    @ResponseBody
    public Map<String, Object> getUserInfo(@RequestParam(value = "userId") String userId, @RequestParam("wxCode") String wxCode, HttpServletRequest request) {
        return service.getById(userId,wxCode);
    }
}
