package hls.support.core.wechat.controllers;

import com.hand.hap.core.impl.RequestHelper;
import hls.support.core.wechat.formbean.UserTag;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.WechatMember;
import hls.support.core.wechat.service.IWechatMemberService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

import org.springframework.validation.BindingResult;

import java.util.List;

@Controller
public class WechatMemberController extends BaseController {

    @Autowired
    private IWechatMemberService service;

    /**
     * 根据member查询用户详细信息
     */
    @RequestMapping(value = "/wechat/member/query/detail")
    @ResponseBody
    public ResponseData queryDetail(WechatMember wechatMember, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                                    @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.queryMemberDetail(requestContext, wechatMember, page, pageSize));
    }

    @RequestMapping(value = "/wechat/member/query")
    @ResponseBody
    public ResponseData query(WechatMember dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value = "/wechat/member/submit")
    @ResponseBody
    public ResponseData update(@RequestBody List<WechatMember> dto, BindingResult result, HttpServletRequest request) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return new ResponseData(service.batchUpdateMember(requestCtx, dto));
    }

    @RequestMapping(value = "/wechat/member/remove")
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<WechatMember> dto) {
        service.batchDelete(dto);
        return new ResponseData();
    }

    /**
     * 根据部门查询用户信息列表
     */
    @RequestMapping(value = "/wechat/member/queryMemberByDepart")
    @ResponseBody
    public ResponseData queryMemberByDepart(WechatMember dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                                            @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = RequestHelper.getCurrentRequest();
        return new ResponseData(service.queryMemberByDepart(requestContext, dto, page, pageSize));
    }

    /**
     * 根据标签查询用户信息列表
     */
    @RequestMapping(value = "/wechat/member/queryMemberByTag")
    @ResponseBody
    public ResponseData queryMemberByTag(WechatMember dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                                         @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = RequestHelper.getCurrentRequest();
        return new ResponseData(service.queryMemberByTag(requestContext, dto, page, pageSize));
    }

    /**
     * 根据标签或者部门查询用户
     */
    @RequestMapping(value = "/wechat/member/queryMember")
    @ResponseBody
    public ResponseData queryMember(WechatMember dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                                    @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = RequestHelper.getCurrentRequest();
        if (dto.getTagId() != null) {
            return new ResponseData(service.queryMemberByTag(requestContext, dto, page, pageSize));
        }
        if (dto.getDepartmentId() != null) {
            return new ResponseData(service.queryMemberByDepart(requestContext, dto, page, pageSize));
        }
        return new ResponseData(service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value = "/wechat/member/batchUpdateUserTag")
    @ResponseBody
    public ResponseData batchAddTag(UserTag userTag, HttpServletRequest request) {
        IRequest requestCtx = RequestHelper.getCurrentRequest();
        if (userTag.getAccountId() == null || StringUtils.isEmpty(userTag.getMemberIds()) || userTag.getTagId() == null) {
            ResponseData responseData = new ResponseData();
            responseData.setSuccess(false);
            responseData.setMessage("one or more params is empty");
            return responseData;
        }
        return service.batchUpdateUserTag(requestCtx, userTag);
    }

}