package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.qq.weixin.mp.aes.WXBizMsgCrypt;
import hls.support.core.wechat.service.IAcceptWechatService;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;

@Controller
public class WechatEnterAcceptAppController extends BaseController {
    private static Logger log = Logger.getLogger(WechatEnterAcceptAppController.class);
    @Autowired
    private IAcceptWechatService service;

    @Value("#{configProperties['qy.wx.token']}")
    private String token;

    @Value("#{configProperties['qy.wx.encodingAESKey']}")
    private String encodingAESKey;

    @Value("#{configProperties['qy.wx.corpId']}")
    private String corpId;

    @Value("#{configProperties['qy.wx.corpSecret']}")
    private String corpSecret;

    /**
     * 验证企业微信服务器，接受企业微信消息推送
     *
     * @param response
     * @param signature
     * @param timestamp
     * @param nonce
     * @param echostr
     */
    @RequestMapping(value = "/accept/wechat/enter/app")
    @ResponseBody
    public void wechatEnterService(PrintWriter out, HttpServletResponse response,
                              HttpServletRequest request,
                              @RequestParam(value = "signature", required = false) String signature,
                              @RequestParam String timestamp,
                              @RequestParam String nonce,
                              @RequestParam(required = false) String echostr,
                              @RequestParam(name = "encrypt_type", required = false) String encType,
                              @RequestParam(name = "msg_signature", required = false) String msgSignature) {
        IRequest iRequest = createRequestContext(request);
        log.info("signature：" + signature + "\ntimestamp：" + timestamp + "\nnonce：" + nonce + "\nechostr：" + echostr);
        if (StringUtils.isNotEmpty(echostr)) {
            if (StringUtils.isNotEmpty(msgSignature)) {
                try {
                    WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(token, encodingAESKey, corpId);
                    out.print(wxcpt.VerifyURL(msgSignature, timestamp, nonce, echostr));
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            out.print("");
        }
    }
}
