package hls.support.core.wechat.controllers;

import org.springframework.stereotype.Controller;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.WechatDepartment;
import hls.support.core.wechat.service.IWechatDepartmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

import org.springframework.validation.BindingResult;

import java.util.List;

@Controller
@RequestMapping("/wechat/department")
public class WechatDepartmentController extends BaseController {

    @Autowired
    private IWechatDepartmentService service;


    @RequestMapping(value = "/query")
    @ResponseBody
    public ResponseData query(WechatDepartment dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value = "/submit")
    @ResponseBody
    public ResponseData update(@RequestBody List<WechatDepartment> dto, BindingResult result, HttpServletRequest request) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return service.batchUpdateDepartment(requestCtx, dto);
        /*return new ResponseData(service.batchUpdate(requestCtx, dto));*/
    }

    @RequestMapping(value = "/remove")
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<WechatDepartment> dto) {
        service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value = "/refresh")
    @ResponseBody
    public ResponseData refresh(HttpServletRequest request, Long accountId) {
        IRequest reusetContext = createRequestContext(request);
        return service.refresh(reusetContext, accountId);
    }

    /**
     * 查询部门列表
     */
    @RequestMapping(value = "/queryDepartment")
    @ResponseBody
    public ResponseData queryDepartment(HttpServletRequest request, WechatDepartment wechatDepartment, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                                        @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.queryDepartment(requestContext, wechatDepartment, page, pageSize));
    }

    /*
    * treeList显示部门及成员
    * */
    @RequestMapping(value = "/treeListDeapartmentQuery")
    @ResponseBody
    public ResponseData treeListDeapartmentQuery(HttpServletRequest request, WechatDepartment wechatDepartment) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.treeListDeapartmentQuery(requestContext, wechatDepartment));
    }


}