package hls.support.core.wechat.controllers;

import org.springframework.stereotype.Controller;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.service.IWechatAccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

import org.springframework.validation.BindingResult;

import java.util.List;

@Controller
@RequestMapping("/wechat/account")
public class WechatAccountController extends BaseController {

    @Autowired
    private IWechatAccountService service;

    /**
     * 根据accountId同步当前公众号的所有通讯录信息
     *
     * @param request
     * @param accountId 公众号id
     * @return responseData
     */
    @RequestMapping(value = "/synchronizeContacts")
    @ResponseBody
    public ResponseData synchronizeData(HttpServletRequest request, Long accountId) {
        IRequest requestContext = createRequestContext(request);
        return service.synchronizeData(requestContext, accountId);
    }

    @RequestMapping(value = "/query")
    @ResponseBody
    public ResponseData query(WechatAccount dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value = "/submit")
    @ResponseBody
    public ResponseData update(@RequestBody List<WechatAccount> dto, BindingResult result, HttpServletRequest request) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return new ResponseData(service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value = "/remove")
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<WechatAccount> dto) {
        service.batchDelete(dto);
        return new ResponseData();
    }
}