package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import hls.support.core.wechat.service.IAcceptWechatService;
import hls.support.core.wechat.service.impl.AcceptWechatNoticeImpl;
import hls.support.core.wechat.utils.WechatCheckUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;

/**
 * Created with IntelliJ IDEA.
 * User: Jeffery
 * Date: 2017/12/21
 * Time: 11:03
 * To change this template use File | Settings | File Templates.
 * 微信公众号服务器配置
 */
@Controller
public class WechatAcceptAppController extends BaseController {

    private static Logger log = Logger.getLogger(WechatAcceptAppController.class);
    @Autowired
    private AcceptWechatNoticeImpl AcceptWechatNoticeImpl;
    @Autowired
    private IAcceptWechatService service;

    @Value("#{configProperties['wx.token']}")
    private String token;

    /**
     * 验证微信服务器，接受微信消息推送
     *
     * @param response
     * @param signature
     * @param timestamp
     * @param nonce
     * @param echostr
     */
    @RequestMapping(value = "/accept/wechat/app")
    @ResponseBody
    public void wechatService(PrintWriter out, HttpServletResponse response,
                              HttpServletRequest request,
                              @RequestParam(value = "signature", required = false) String signature,
                              @RequestParam String timestamp,
                              @RequestParam String nonce,
                              @RequestParam(required = false) String echostr,
                              @RequestParam(name = "encrypt_type", required = false) String encType,
                              @RequestParam(name = "msg_signature", required = false) String msgSignature) {
        IRequest iRequest = createRequestContext(request);
        log.info("signature：" + signature + "\ntimestamp：" + timestamp + "\nnonce：" + nonce + "\nechostr：" + echostr);
        if (StringUtils.isNotEmpty(echostr)) {
            if (WechatCheckUtil.checkSignature(token,signature, timestamp, nonce)) {
                log.info(echostr);
                out.print(echostr);
            }

        } else {
            service.filterSubscribe(request, response, iRequest);

        }
    }

    /**
     * 接收来自微信发来的消息
     *
     * @param out
     * @param request
     * @param response
     */
    @ResponseBody
    @RequestMapping(value = "/accept/wechat", method = RequestMethod.POST)
    public void wechatServicePost(PrintWriter out, HttpServletRequest request, HttpServletResponse response) {
        String responseMessage = AcceptWechatNoticeImpl.processRequest(request);
        out.print(responseMessage);
        out.flush();
    }

}
