package hls.support.core.wechat.controllers;

import org.springframework.stereotype.Controller;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.SubButton;
import hls.support.core.wechat.service.ISubButtonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

import org.springframework.validation.BindingResult;

import java.util.List;

@Controller
@RequestMapping("/sub/button")
public class SubButtonController extends BaseController {

    @Autowired
    private ISubButtonService service;


    @RequestMapping(value = "/query")
    @ResponseBody
    public ResponseData query(SubButton dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value = "/submit")
    @ResponseBody
    public ResponseData update(@RequestBody List<SubButton> dto, BindingResult result, HttpServletRequest request) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return new ResponseData(service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value = "/remove")
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<SubButton> dto) {
        service.batchDelete(dto);
        return new ResponseData();
    }

    /*自定义菜单查询*/
    @RequestMapping(value = "/queryAll")
    @ResponseBody
    public ResponseData queryAll(HttpServletRequest request, SubButton subButton) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.queryAll(requestContext, subButton));
    }

    /*自定义菜单插入*/
    @RequestMapping(value = "/updateMenu")
    @ResponseBody
    public ResponseData updateMenu(HttpServletRequest request, @RequestBody List<SubButton> subButtons) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.updateMenu(requestContext, subButtons));
    }

    /*删除主菜单*/
    @RequestMapping(value = "/deleteMenu")
    @ResponseBody
    public ResponseData deleteMenu(HttpServletRequest request, @RequestBody SubButton subButton) {
        IRequest requestContext = createRequestContext(request);
        service.deleteMenu(requestContext, subButton);
        return new ResponseData();
    }

    /*发布菜单*/
    @RequestMapping(value = "/push")
    @ResponseBody
    public ResponseData push(Long wechatId) {
        return service.pushMenu(wechatId);
    }
}