package hls.support.core.wechat.controllers;

import com.hand.hap.attachment.dto.SysFile;
import com.hand.hap.core.IRequest;
import com.hand.hap.security.TokenUtils;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.HlsWechatNoticeRecord;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.service.IHlsWechatNoticeRecordService;
import hls.support.core.wechat.service.IWechatAccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: Jeffery
 * Date: 2017/12/7
 * Time: 15:56
 * To change this template use File | Settings | File Templates.
 */
@RestController
@RequestMapping("/wechat/notice")
public class HlsNoticeRecordController extends BaseController {

    @Autowired
    private IHlsWechatNoticeRecordService hlsWechatNoticeRecordService;
    @Autowired
    private IWechatAccountService service;

    @RequestMapping("/add")
    @ResponseBody
    public List<HlsWechatNoticeRecord> addAccount(final HlsWechatNoticeRecord dto, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return hlsWechatNoticeRecordService.addNotice(requestContext, dto);
    }

    @RequestMapping("/enterprise/query")
    @ResponseBody
    public List<WechatAccount> queryEnterpriseAccount(final WechatEnterpriseApp dto, HttpServletRequest request) {
        return service.selectAll(this.createRequestContext(request));
    }

    @RequestMapping("/query")
    public ResponseData queryAccountsList(HlsWechatNoticeRecord dto, HttpServletRequest request,
                                          @RequestParam(value = "page", required = false, defaultValue = DEFAULT_PAGE) int page,
                                          @RequestParam(value = "pageSize", required = false, defaultValue = DEFAULT_PAGE_SIZE) int pageSize) {
        List<HlsWechatNoticeRecord> list = hlsWechatNoticeRecordService.select(this.createRequestContext(request), dto, page, pageSize);
        String securityKey = TokenUtils.getSecurityKey(request.getSession());
        SysFile file = new SysFile();
        for (HlsWechatNoticeRecord f : list) {
            file.setFileId(f.getFileId());
            f.set_token(TokenUtils.generateToken(securityKey, file));
        }
        return new ResponseData(list);
    }

    @RequestMapping("/delete")
    public ResponseData queryAccountsDelete(HlsWechatNoticeRecord dto, HttpServletRequest request) {
        return new ResponseData((hlsWechatNoticeRecordService.deleteByPrimaryKey(dto) > 0) ? true : false);
    }

}
