package hls.support.core.wechat.components;

import hls.support.core.wechat.dto.AutoRecover;
import hls.support.core.wechat.service.IAutoRecoverService;
import me.chanjar.weixin.mp.api.WxMpMessageMatcher;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.regex.Pattern;

@Component
public class MessageMatcher implements WxMpMessageMatcher {

    @Autowired
    private IAutoRecoverService service;
    private static MessageMatcher messageMatcher;
    private static String MATCH_FLAG_TRUE = "true";
    private static String MATCH_FLAG_FALSE = "false";
    private String flag = MATCH_FLAG_FALSE;

    public void setIAutoRecoverService(IAutoRecoverService service) {
        this.service = service;
    }

    @PostConstruct
    public void init() {
        messageMatcher = this;
        messageMatcher.service = this.service;
    }

    @Override
    public boolean match(WxMpXmlMessage wxMpXmlMessage) {
        List<AutoRecover> messages = MessageMatcher.messageMatcher.service.queryAll();
        for (AutoRecover message : messages) {
            if (Pattern.matches(".*" + message.getContent() + ".*", wxMpXmlMessage.getContent())) {
                flag = MATCH_FLAG_TRUE;
                break;
            }
            flag = MATCH_FLAG_FALSE;
        }
        if (flag == MATCH_FLAG_TRUE) {
            return true;
        } else {
            return false;
        }
    }

}
