package hls.support.core.wechat.components;

import hls.support.core.wechat.dto.AutoRecover;
import hls.support.core.wechat.mapper.AutoRecoverMapper;
import hls.support.core.wechat.service.IAutoRecoverService;
import me.chanjar.weixin.common.api.WxConsts;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

@Component
public class MessageHandler implements WxMpMessageHandler {

    @Autowired
    private AutoRecoverMapper mapper;
    private static MessageHandler messageHandler;

    private static int THE_FIRST_PICK = 0;
    private String targetStr = "text";

    @PostConstruct
    public void init() {
        messageHandler = this;
        messageHandler.mapper = this.mapper;
    }

    @Override
    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMpXmlMessage, Map<String, Object> map, WxMpService wxMpService, WxSessionManager wxSessionManager) throws WxErrorException {
        WxMpXmlOutMessage xmlOutMsg = null;
        if (wxMpXmlMessage.getMsgType().equals(WxConsts.XmlMsgType.TEXT)) {
            List<AutoRecover> messages = MessageHandler.messageHandler.mapper.queryAll();
            for (AutoRecover message : messages) {
                if (Pattern.matches(".*" + message.getContent() + ".*", wxMpXmlMessage.getContent())) {
                    targetStr = message.getContent();
                    break;
                }
            }
            AutoRecover autoRecover = new AutoRecover();
            autoRecover.setContent(targetStr);
            xmlOutMsg = WxMpXmlOutMessage.TEXT().content(MessageHandler.messageHandler.mapper.selectSeq(autoRecover).get(THE_FIRST_PICK).getReContent()).toUser(wxMpXmlMessage.getFromUser()).fromUser(wxMpXmlMessage.getToUser()).build();
        }
        return xmlOutMsg;
    }
}
