package hls.support.core.sys.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.ISysConfigService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.sys.dto.SysChannelManage;
import hls.support.core.sys.dto.SysCustMasterData;
import hls.support.core.sys.mapper.SysCustMasterDataMapper;
import hls.support.core.sys.service.ISysChannelManageService;
import hls.support.core.sys.service.ISysCustMasterDataService;
import hls.support.core.sys.utils.SysCustDataSql;
import hls.support.core.wechat.service.impl.AcceptWechatNoticeImpl;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import java.sql.*;
import java.util.ArrayList;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: Jeffery
 * Date: 2018/3/29
 * Time: 17:20
 * To change this template use File | Settings | File Templates.
 */
@Service
public class SysCustMasterDataServiceImpl extends BaseServiceImpl<SysCustMasterData> implements ISysCustMasterDataService {
    @Autowired
    private ISysConfigService sysConfigService;
    @Autowired
    private SysCustMasterDataMapper sysCustMasterDataMapper;
    private static Logger logger = Logger.getLogger(AcceptWechatNoticeImpl.class);

    @Override
    public ResponseData addOrUpdate(IRequest requestCtx, List<SysCustMasterData> dtoList) {
        List<SysCustMasterData> updateList = new ArrayList<>();
        for (SysCustMasterData dto : dtoList) {
            List<SysCustMasterData> curList = sysCustMasterDataMapper.queryInfoByBpId(dto);
            if(curList.size()>0){
                dto.set__status("update");
                dto.setCustId(curList.get(0).getCustId());
            }else {
                dto.set__status("add");
            }
            updateList.add(dto);
        }
        return new ResponseData(self().batchUpdate(requestCtx,updateList));
    }

    public void SynCustMasterData() {
        PreparedStatement statementChk = null;
        ResultSet resChk = null;
        PreparedStatement statement = null;
        ResultSet res = null;
        Connection conn = null;
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
            conn = DriverManager.getConnection(sysConfigService.getConfigValue("BI_DB_URL"),sysConfigService.getConfigValue("BI_DB_USER"),sysConfigService.getConfigValue("BI_DB_PASSWORD"));
            //将事务模式设置为手动提交事务：
            conn.setAutoCommit(false);
            //设置事务的隔离级别。
            conn.setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
            statementChk = conn.prepareStatement(SysCustDataSql.fpSql);
            resChk = statementChk.executeQuery();
            resChk.next();
            if(resChk.getString("FLAG").equals("1")){
                String custEtlDate = resChk.getString("ETL_DATE");
                Long custDataSize = sysCustMasterDataMapper.queryInfoSize(custEtlDate);
                if(custDataSize==0){
                    statementChk.close();
                    resChk.close();
                    statement = conn.prepareStatement(SysCustDataSql.dataSql);
                    statement.setString(1,custEtlDate);
                    statement.setString(2,custEtlDate);
                    statement.setString(3,custEtlDate);
                    statement.setString(4,custEtlDate);
                    res = statement.executeQuery();
                    saveCustData(res);
                }
            }
            conn.close();
        }catch (Exception e){
            e.getMessage();
        }finally{
            try {
                if(res !=null)res.close();
            } catch (Exception e) {
                logger.error(e.getMessage());
            }

            try {
                if(statement !=null)statement.close();
            } catch (Exception e) {
                logger.error(e.getMessage());
            }

            try {
                if(conn !=null)conn.close();
            } catch (Exception e) {
                logger.error(e.getMessage());
            }

        }
    }

    private boolean saveCustData(ResultSet res){
        boolean rtnFlag = false;
        try {
            while(res.next()){
                SysCustMasterData dto = new SysCustMasterData();
                dto.setBpId(res.getString("bpId"));
                dto.setCustCard(res.getString("custCard"));
                dto.setCustMail(res.getString("custMail"));
                dto.setCustName(res.getString("custName"));
                dto.setCustOpenId(res.getString("custOpenId"));
                dto.setCustPhone(res.getString("custPhone"));
                dto.setCustConNumber(res.getString("conNum"));
                dto.setCustEtlDate(res.getString("etlDate"));
                dto.setCustRole(res.getString("custRole"));
                dto.set__status("add");
                sysCustMasterDataMapper.insertSelective(dto);
            }
            rtnFlag = true;
        }catch (Exception e){
            rtnFlag = false;
            e.getMessage();
        }
        return rtnFlag;
    }
}
