package hls.support.core.sys.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import com.itextpdf.text.log.SysoCounter;
import hls.support.core.sys.dto.SysChannelManage;
import hls.support.core.sys.dto.SysChannelNotice;
import hls.support.core.sys.dto.SysChannelPassManage;
import hls.support.core.sys.bean.CommonMessageBean;
import hls.support.core.sys.mapper.SysChannelManageMapper;
import hls.support.core.sys.mapper.SysChannelNoticeMapper;
import hls.support.core.sys.mapper.SysChannelPassManageMapper;
import hls.support.core.sys.service.ISysChannelManageService;
import hls.support.core.sys.service.ISysChannelSendService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.*;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Created with IntelliJ IDEA.
 * User: Jeffery
 * Date: 2018/3/8
 * Time: 17:36
 * To change this template use File | Settings | File Templates.
 */
@Service
public class SysChannelManageServiceImpl extends BaseServiceImpl<SysChannelManage> implements ISysChannelManageService, ApplicationContextAware {
    @Autowired
    private SysChannelManageMapper sysChannelManageMapper;
    @Autowired
    private SysChannelPassManageMapper sysChannelPassManageMapper;

    private Map<String, ISysChannelSendService> sysChannelSendServiceMap;

    @Autowired
    private SysChannelNoticeMapper sysChannelNoticeMapper;

    @Value("#{configProperties['thread.taskSize']}")
    private String thredTaskSize;

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public List sendMsgByChannel(IRequest requestContext, List<CommonMessageBean> dtoList) throws ExecutionException, InterruptedException {
        List rtnList = new ArrayList();
        logger.debug("*******开始多线程并发*********");
        Date startDate = new Date();
        //初始化多少线程
        int taskSize = Integer.parseInt(thredTaskSize);//5
        //每个线程需要执行多少天消息
        int taskDoCount = (dtoList.size() % taskSize == 0) ? (dtoList.size() / taskSize) : ((dtoList.size() / taskSize) + 1);//2   0-2 2-4 4-6 6-8 8-10
        // 创建一个线程池
        ExecutorService pool = Executors.newFixedThreadPool(taskSize);
        // 创建多个有返回值的任务
        List<Future> list = new ArrayList<Future>();
        if (taskSize < dtoList.size()) {
            for (int i = 0; i < taskSize; i++) {
                int startIndex = i * taskDoCount; //0 2 4 6
                int endIndex = 0;
                if (i * taskDoCount < dtoList.size()) {
                    endIndex = (i + 1) * taskDoCount;  //2 4 6
                } else {
                    endIndex = dtoList.size() - 1;
                }
                List<CommonMessageBean> param = dtoList.subList(startIndex, endIndex);
                Callable c = new MyCallable(requestContext, param);
                // 执行任务并获取Future对象
                Future<List> f = pool.submit(c);
                list.add(f);
            }
        } else {
            Callable c = new MyCallable(requestContext, dtoList);
            // 执行任务并获取Future对象
            Future<List> f = pool.submit(c);
            list.add(f);
        }
        // 关闭线程池
        pool.shutdown();
        try {
            //等待直到所有任务完成
//            pool.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
            // 获取所有并发任务的运行结果
            for (Future<List> f : list) {
                // 从Future对象上获取任务的返回值
                for (Object obj : Arrays.asList(f.get())) {
                    //FutureTak不能直接转List  将多个线程染回的List组合成一个List返回
                    for (int p = 0; p < ((ArrayList) obj).size(); p++) {
                        rtnList.add(((ArrayList) obj).get(p));
                    }
                }
            }
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        Date endDate = new Date();
        logger.debug("*****多线程运行结束*****，" +
                "总发送时间为：【" + (endDate.getTime() - startDate.getTime()) + "毫秒】");
        return rtnList;
    }

    //查询定义好的发送顺序，按顺序调用相关接口发送
    private Map foreachList(IRequest requestContext, CommonMessageBean messageBean) {
        ResponseData responseData = new ResponseData();
        Map rtMap = new HashMap();
        //按照消息类型查询渠道管理方式，表结构已是按照type建了唯一索引
        List<SysChannelManage> dtoList = sysChannelManageMapper.queryChannelByType(messageBean.getSendMsgType());
        //如果黑名单中有人则过滤
        if (dtoList.get(0).getBlacklist() != null && !"".equals(dtoList.get(0).getBlacklist())) {
            messageBean = checkBlackList(messageBean, dtoList.get(0).getBlacklist());
        }
        //判空
        if (CollectionUtils.isNotEmpty(dtoList) && dtoList.get(0).getEnableFlag().equals("Y")) {
            SysChannelManage channelManage = dtoList.get(0);
            //以此执行如果成功则立即停止
            for (int i = 0; i < channelManage.getDoStr().split(",").length; i++) {
                //根据类型选择通道发送
                rtMap = orderSend(requestContext, messageBean, channelManage.getDoStr().split(",")[i]);
                //如果发送成功则停止
                if (responseData.isSuccess()) {
                    break;
                } else {
                    logger.warn("unknown error !");
                    rtMap.put("message", "实现类错误或消息类型没有启用");
                    rtMap.put("success", "false");
                }
            }
        } else {
            logger.warn("channel is not found or enable is false !");
            rtMap.put("documentNumber", messageBean.getDocumentNumber());
            rtMap.put("batchid", "");
            rtMap.put("toChannel", "");
            rtMap.put("fromChannel", messageBean.getFromChannel());
            rtMap.put("message", "渠道管理方式不存在或者渠道管理方式未启用");
            rtMap.put("success", "false");
        }
        return rtMap;
    }

    //按顺序发送
    private Map orderSend(IRequest requestContext, CommonMessageBean dto, String type) {
        Map rtMap = new HashMap();
        ResponseData responseData;
        //根据通道类型查询改通道是否关闭
        List<SysChannelPassManage> channelList = sysChannelPassManageMapper.queryPassByValue(type);
        //如果通道是关闭的则直接返回false
        if (channelList.size() > 0 && channelList.get(0).getEnableFlag().equals("Y")) {
            SysChannelPassManage channel = channelList.get(0);
            //判断走哪一条通道
            ISysChannelSendService sysChannelSendService;
            //判断通道是否为短信，如果是根据概率选择发送实现类
            if (channel.getPassValue().equals("sms")) {
                Float ltPb = channel.getLtPb();
                Float xwPb = channel.getXwPb();
                //短信通道两种发送方式的分配率不能为空
                if (ltPb == null && xwPb == null) {
                    rtMap.put("message", "请配置短信的发送分配率");
                    return rtMap;
                }
                sysChannelSendService = randomSmsSend(ltPb);
            }
            //否则根据通道配置的类名进行发送
            else {
                sysChannelSendService = sysChannelSendServiceMap.get(channel.getPassClass());
            }
            try {
                responseData = sysChannelSendService.sendMsg(requestContext, dto);
                if (responseData.isSuccess()) {
                    rtMap.put("message", "发送成功");
                    rtMap.put("success", "true");
                } else {
                    rtMap.put("message", responseData.getMessage());
                    rtMap.put("success", responseData.isSuccess());
                }
                rtMap.put("batchid", responseData.getCode());
            } catch (Exception e) {
                logger.warn(e.getMessage());
                rtMap.put("batchid", "");
                rtMap.put("success", "false");
                rtMap.put("message", "发送消息实现类存在问题");
            }
        } else {
            logger.warn("noticeType is not found or enable is false !");
            rtMap.put("batchid", "");
            rtMap.put("success", "false");
            rtMap.put("message", "不存在消息类型或者消息类型没有启用");
        }
        rtMap.put("toChannel", type);
        rtMap.put("fromChannel", ((dto.getFromChannel() != null) ? (dto.getFromChannel()) : ""));
        rtMap.put("documentNumber", dto.getDocumentNumber());
        if (dto != null) {
            if (saveChannelNotice(requestContext, dto, type, rtMap)) {
                logger.debug("消息保存成功");
            } else {
                logger.debug("消息保存失败");
            }
        }
        return rtMap;
    }

    @Override
    public List<SysChannelManage> update(IRequest requestContext, List<SysChannelManage> list) {
        if (list.size() > 0) {
            for (SysChannelManage dto : list) {
                sysChannelManageMapper.updateByPrimaryKey(dto);
            }
        }
        return sysChannelManageMapper.selectAll();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map<String, ISysChannelSendService> beansOfType = applicationContext.getBeansOfType(ISysChannelSendService.class);
        sysChannelSendServiceMap = new HashMap<>(beansOfType.size());
        beansOfType.forEach((k, v) -> {
            sysChannelSendServiceMap.put(v.getCode(), v);
        });
    }

    /**
     * 根据概率选择发实现送类
     *
     * @param ltPb 联通发送概率
     */
    private ISysChannelSendService randomSmsSend(Float ltPb) {
        int num = (int) (Math.random() * 100);
        if (num >= 0 && num < ltPb * 100) {
            return sysChannelSendServiceMap.get("hls.support.core.sys.service.impl.SmsSendServiceImpl");
        }
        return sysChannelSendServiceMap.get("hls.support.core.sys.service.impl.XwSmsSendServiceImpl");
    }

    /**
     * 黑名过滤
     */
    private CommonMessageBean checkBlackList(CommonMessageBean dto, String blackList) {
        //黑名单
        String[] rmBlackLsit = blackList.split(",|，|；|;|、|/|[\t \n]+| +| ");
        List<String> black = new ArrayList<String>(Arrays.asList(rmBlackLsit));
        String phoneStr = "";
        String mailStr = "";
        String wechatStr = "";
        //手机列表
//        if (dto.getMessageConfig().getPhone() != null && !"".equals(dto.getMessageConfig().getPhone())) {
//            String[] phoneList = dto.getMessageConfig().getPhone().split(",|，|；|;|、|/|[\t \n]+| +| ");
//            List<String> rmPhoneList = new ArrayList<>(Arrays.asList(phoneList));
//            for (String blackStr : black) {
//                if (rmPhoneList.contains(blackStr)) {
//                    rmPhoneList.remove(blackStr);
//                }
//            }
//            phoneStr = rmPhoneList.toString().replace("[", "").replace("]", "");
//        }

        //邮件列表
        if (dto.getEmailParams().get("receivers") != null && !"".equals(dto.getEmailParams().get("receivers"))) {
            String[] mailList = dto.getEmailParams().get("receivers").toString().split(",|，|；|;|、|/|[\t \n]+| +| ");
            List<String> rmMailList = new ArrayList<>(Arrays.asList(mailList));
            for (String blackStr : black) {
                if (rmMailList.contains(blackStr)) {
                    rmMailList.remove(blackStr);
                }
            }
            mailStr = rmMailList.toString().replace("[", "").replace("]", "");
        }

        //微信列表
        if (dto.getWxMessageBean().getOpenId() != null && !"".equals(dto.getWxMessageBean().getOpenId())) {
            String[] wxList = dto.getWxMessageBean().getOpenId().split(",|，|；|;|、|/|[\t \n]+| +| ");
            List<String> rmWxList = new ArrayList<>(Arrays.asList(wxList));
            for (String blackStr : black) {
                if (rmWxList.contains(blackStr)) {
                    rmWxList.remove(blackStr);
                }
            }
            wechatStr = rmWxList.toString().replace("[", "").replace("]", "");
        }
        //dto.getMessageConfig().setPhone(phoneStr);
        dto.getEmailParams().put("receivers", mailStr);
        dto.getWxMessageBean().setOpenId(wechatStr);
        return null;
    }

    /*
    * 保存接受到消息
    *
    * */
    private boolean saveChannelNotice(IRequest requestContext, CommonMessageBean dto, String type, Map map) {
        boolean rtnFlag = false;
        SysChannelNotice sysChannelNotice = new SysChannelNotice();
        //通用字段
        sysChannelNotice.setBpId(dto.getBp_id());
        sysChannelNotice.setContent(dto.getContent());
        sysChannelNotice.setSendMsgType(dto.getSendMsgType());
        sysChannelNotice.setFromChannel(dto.getFromChannel());
        sysChannelNotice.setMessageType(dto.getMessageType());
        sysChannelNotice.setToChannel(type);
        sysChannelNotice.setDocNum(dto.getDocumentNumber());
        sysChannelNotice.setSendSuccess((map.get("success") != null) ? map.get("success").toString() : "");
        sysChannelNotice.setReturnMessage((map.get("message") != null) ? map.get("message").toString() : "");
        //微信
        sysChannelNotice.setOpenId((dto.getWxMessageBean() != null) ? dto.getWxMessageBean().getOpenId() : "");
        sysChannelNotice.setTemplateId((dto.getWxMessageBean() != null) ? dto.getWxMessageBean().getTemplateId() : "");
        //短信
       // sysChannelNotice.setPhone((dto.getMessageConfig() != null) ? dto.getMessageConfig().getPhone() : "");
        //邮件
        sysChannelNotice.setReceivers((dto.getEmailParams().get("receivers") != null) ? dto.getEmailParams().get("receivers").toString() : "");
        sysChannelNotice.setSubject((dto.getEmailParams().get("subject") != null) ? dto.getEmailParams().get("subject").toString() : "");
        int flag = 0;
        try {
            flag = sysChannelNoticeMapper.insertSelective(sysChannelNotice);
        } catch (Exception e) {
            flag = -1;
            logger.debug(e.getMessage());
        }
        rtnFlag = flag > 0 ? true : false;
        return rtnFlag;
    }

    /*
    * 判断类型并发送
    * */
    private List sendNoticeList(IRequest iRequest, List dtoList) {
        List list = new ArrayList<>();
        int j = 0;
        for (int i = 0; i < dtoList.size(); i++) {
            j++;
            System.out.println("******************当前下标：" + j);
            if (((CommonMessageBean) dtoList.get(i)).getSendMsgType().equals("USER_DEFINED_SEND")) {
                System.out.println("******************我走了上面的if：" + ((CommonMessageBean) dtoList.get(i)).getContent());
                list.add(orderSend(iRequest, ((CommonMessageBean) dtoList.get(i)), ((CommonMessageBean) dtoList.get(i)).getMessageType()));
            } else {
                System.out.println("******************我走了下面的else：" + ((CommonMessageBean) dtoList.get(i)).getContent());
                list.add(foreachList(iRequest, ((CommonMessageBean) dtoList.get(i))));
            }
        }
        return list;
    }

    /*
    * 内部类多线程并发
    * */
    class MyCallable implements Callable<List> {
        private List dtoList;
        private IRequest iRequest;

        MyCallable(IRequest iRequest, List dtoList) {
            this.dtoList = dtoList;
            this.iRequest = iRequest;
        }

        public List call() throws Exception {
            if (CollectionUtils.isNotEmpty(dtoList)) {
                return sendNoticeList(iRequest, dtoList);
            } else {
                List list = new ArrayList<>();
                Map rtMap = new HashMap();
                rtMap.put("success", "false");
                rtMap.put("documentNumber", "");
                rtMap.put("batchid", "");
                rtMap.put("toChannel", "");
                rtMap.put("fromChannel", "");
                rtMap.put("message", "没有接受到数据");
                list.add(rtMap);
                return list;
            }
        }
    }

}
