package hls.support.core.sys.service.impl;

import com.hand.hap.core.IRequest;

import com.hand.hap.system.dto.ResponseData;
import hls.support.core.sys.bean.CommonMessageBean;
import hls.support.core.sys.service.ISysChannelSendService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Created by weck on 26/03/2018 1:27 PM
 */
@Service
public class MailSendServiceImpl implements ISysChannelSendService{
    private static final String ERROR_REQUIRED_PARAMETER_DATA_NULL = "ERROR_REQUIRED_PARAMETER_DATA_NULL";
    private static final Logger logger = LoggerFactory.getLogger(MailSendServiceImpl.class);
    @Autowired
    //private ISendMailService sendMailService;
    @Override
    public String getCode() {
        return "hls.support.core.sys.service.impl.MailSendServiceImpl";
    }

    @Override
    public ResponseData sendMsg(IRequest requestContext, CommonMessageBean messageBean) {
        ResponseData responseData = new ResponseData(false);
        Map<String,Object> emailParams = messageBean.getEmailParams();
        if (emailParams==null){
            logger.error(ERROR_REQUIRED_PARAMETER_DATA_NULL);
            responseData.setMessage(ERROR_REQUIRED_PARAMETER_DATA_NULL);
            return responseData;
        }
        emailParams.put("content",messageBean.getContent());
        emailParams.put("mode","userDefined");
       // responseData = sendMailService.sendMessage(requestContext,emailParams);
        return null;
    }
}
