package hls.support.core.sys.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.sys.dto.SysChannelNotice;
import hls.support.core.sys.dto.SysCustMasterData;
import hls.support.core.sys.service.ISysCustMasterDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: Jeffery
 * Date: 2018/3/29
 * Time: 17:17
 * To change this template use File | Settings | File Templates.
 */
@Controller
public class SysCustMasterDataController extends BaseController {
    @Autowired
    private ISysCustMasterDataService sysCustMasterDataService;

    /*
    * @Author Jerffery
    * 同步客户主数据
    *
    * */
    @RequestMapping(value = {"/r/api/sync/custom/data","/sync/custom/data"})
    @ResponseBody
    public ResponseData syncCustData(HttpServletRequest request, @RequestBody List<SysCustMasterData> dtoList,BindingResult result){
        IRequest requestCtx = createRequestContext(request);
        getValidator().validate(dtoList, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        sysCustMasterDataService.addOrUpdate(requestCtx,dtoList);
        return new ResponseData();
    }

   /*
    * @Author Jerffery
    * 渠道管理查询全部的信息
    *
    * */
    @RequestMapping(value = "/sys/cust/master/data/query")
    @ResponseBody
    public ResponseData query(SysCustMasterData dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(sysCustMasterDataService.select(requestContext, dto, page, pageSize));
    }
}
