package hls.support.core.sys.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.sys.dto.SysChannelManage;
import hls.support.core.sys.dto.SysChannelNotice;
import hls.support.core.sys.service.ISysChannelNoticeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * Created with IntelliJ IDEA.
 * User: Jeffery
 * Date: 2018/5/2
 * Time: 14:25
 * To change this template use File | Settings | File Templates.
 */
@Controller
public class SysChannelNoticeController extends BaseController {
    @Autowired
    private ISysChannelNoticeService sysChannelNoticeService;
    /*
     * @Author Jerffery
     * 渠道管理查询全部的信息
     *
     * */
    @RequestMapping(value = "/sys/channel/notice/query")
    @ResponseBody
    public ResponseData query(SysChannelNotice dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(sysChannelNoticeService.select(requestContext, dto, page, pageSize));
    }
}
