package hls.support.core.sys.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.sys.bean.CommonMessageBean;
import hls.support.core.sys.dto.SysChannelManage;
import hls.support.core.sys.service.ISysChannelManageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

/**
 * Created with IntelliJ IDEA.
 * User: Jeffery
 * Date: 2018/3/8
 * Time: 17:38
 * To change this template use File | Settings | File Templates.
 */
@Controller
public class SysChannelManageController extends BaseController {
    @Autowired
    private ISysChannelManageService sysChannelManageService;

    /*
    * @Author Jerffery
    * 渠道管理查询全部的信息
    *
    * */
    @RequestMapping(value = "/sys/channel/manage/query")
    @ResponseBody
    public ResponseData query(SysChannelManage dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(sysChannelManageService.select(requestContext, dto, page, pageSize));
    }

    /*
   * @Author Jerffery
   * 添加渠道管理
   *
   * */
    @RequestMapping(value = "/sys/channel/manage/save")
    @ResponseBody
    public ResponseData save(@RequestBody List<SysChannelManage> dto, BindingResult result, HttpServletRequest request) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return new ResponseData(sysChannelManageService.batchUpdate(requestCtx, dto));
    }

    /*
 * @Author Jerffery
 * 添加渠道管理
 *
 * */
    @RequestMapping(value = "/sys/channel/manage/update")
    @ResponseBody
    public ResponseData update(@RequestBody List<SysChannelManage> dto, BindingResult result, HttpServletRequest request) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        sysChannelManageService.update(requestCtx, dto);
        return new ResponseData();
    }


    /*
    * @Author Jerffery
    * 删除渠道管理
    *
    * */
    @RequestMapping(value = "/sys/channel/manage/delete")
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<SysChannelManage> dto) {
        sysChannelManageService.batchDelete(dto);
        return new ResponseData();
    }

    /*
    * @Author Jerffery
    * 接受发送消息，按顺序发送
    *
    * */
    @RequestMapping(value = {"/r/api/sys/channel/manage/send/notice","/view/sys/channel/manage/send/notice"})
    @ResponseBody
    public List sendChannelNotice(HttpServletRequest request, @RequestBody List<CommonMessageBean> dtoList) throws ExecutionException, InterruptedException{
        IRequest requestCtx = createRequestContext(request);
        return sysChannelManageService.sendMsgByChannel(requestCtx,dtoList);
    }

}
