package com.hand.hap.intergration.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class HttpUtil {
    public static final int CODE_REQUEST_FAILED = -1;
    private static Logger logger = LoggerFactory.getLogger(HttpUtil.class);

    public static HttpResponse postJson(String url, JSONObject params, JSONObject headers) {
        JSONObject jsonObject = new JSONObject();
        HttpResponse execute = null;
        HttpClient httpClient = wrapClient(url);
        try {
            HttpPost post = new HttpPost(url);
            if (headers != null) {
                for (String name : headers.keySet()) {
                    post.setHeader(name, headers.get(name).toString());
                }
            }
            if (params != null) {
                HttpEntity param = new StringEntity(JSON.toJSONString(params), ContentType.APPLICATION_JSON);
                post.setEntity(param);
            }
            execute = httpClient.execute(post);
            // execute.getStatusLine().getStatusCode();
        } catch (IOException e) {
            //jsonObject.put("code", CODE_REQUEST_FAILED);
            //jsonObject.put("message", e.getMessage());
            logger.error("client execute failed: ", e);
        }
        return execute;
    }

    public static HttpResponse postFormUrlEncoded(String url, JSONObject params, JSONObject headers) {
        JSONObject jsonObject = new JSONObject();
        HttpResponse execute = null;
        HttpClient httpClient = wrapClient(url);
        try {
            HttpPost post = new HttpPost(url);
            if (headers != null) {
                for (String name : headers.keySet()) {
                    post.setHeader(name, headers.get(name).toString());
                }
            }
            if (params != null) {
                List<NameValuePair> nameValuePairList = new ArrayList<NameValuePair>();
                for (String key : params.keySet()) {
                    nameValuePairList.add(new BasicNameValuePair(key, params.get(key).toString()));
                }
                UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(nameValuePairList, "utf-8");
                formEntity.setContentType("application/x-www-form-urlencoded; charset=UTF-8");
                post.setEntity(formEntity);
            }
            execute = httpClient.execute(post);
        } catch (IOException e) {
            // jsonObject.put("code", CODE_REQUEST_FAILED);
            // jsonObject.put("message", e.getMessage());
            logger.error("client execute failed: ", e);
        }
        return execute;
    }
    public static HttpResponse postOcStremJson(String url, JSONObject params, JSONObject headers) {
        JSONObject jsonObject = new JSONObject();
        HttpResponse execute = null;
        HttpClient httpClient = wrapClient(url);
        try {
            HttpPost post = new HttpPost(url);
            if (headers != null) {
                for (String name : headers.keySet()) {
                    post.setHeader(name, headers.get(name).toString());
                }
            }
            if (params != null) {
                HttpEntity param = new StringEntity(JSON.toJSONString(params), ContentType.APPLICATION_OCTET_STREAM);
                post.setEntity(param);
            }
            execute = httpClient.execute(post);
            // execute.getStatusLine().getStatusCode();
        } catch (IOException e) {
            //jsonObject.put("code", CODE_REQUEST_FAILED);
            //jsonObject.put("message", e.getMessage());
            logger.error("client execute failed: ", e);
        }
        return execute;
    }

    public static HttpResponse getJson(String url, JSONObject headers) {
        JSONObject jsonObject = new JSONObject();
        HttpResponse execute = null;
        HttpClient httpClient = wrapClient(url);
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(5000)   //设置连接超时时间
                .setConnectionRequestTimeout(5000) // 设置请求超时时间
                .setSocketTimeout(5000)
                .setRedirectsEnabled(true)//默认允许自动重定向
                .build();

        try {
            HttpGet get = new HttpGet(url);
            if (headers != null) {
                for (String name : headers.keySet()) {
                    get.setHeader(name, headers.get(name).toString());
                }
            }
            get.setConfig(requestConfig);
            execute = httpClient.execute(get);
        } catch (IOException e) {
            // jsonObject.put("code", CODE_REQUEST_FAILED);
            // jsonObject.put("message", e.getMessage());
            logger.error("client execute failed: ", e);
        }
        return execute;
    }

    public static String HttpResponseParseJson(HttpResponse execute) throws  Exception{
        String result="";
        if (execute != null) {
            HttpEntity entity = execute.getEntity();
            try {
                result = EntityUtils.toString(entity, "utf-8");
            } catch (IOException e) {
                logger.error("entity parse failed: ", e);
                throw e;
            }
        }
        return result;

    }


    private static HttpClient wrapClient(String url) {
        HttpClient httpClient = new DefaultHttpClient();
        if (url.startsWith("https://")) {
            sslClient(httpClient);
        }

        return httpClient;
    }

    private static void sslClient(HttpClient httpClient) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager() {
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] xcs, String str) {
                }

                public void checkServerTrusted(X509Certificate[] xcs, String str) {
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx);
            ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            ClientConnectionManager ccm = httpClient.getConnectionManager();
            SchemeRegistry registry = ccm.getSchemeRegistry();
            registry.register(new Scheme("https", 443, ssf));
        } catch (KeyManagementException ex) {
            throw new RuntimeException(ex);
        } catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

}
