//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.hand.hap.intergration.controllers;

import com.alibaba.fastjson.JSONObject;
import com.codahale.metrics.annotation.Timed;
import com.hand.hap.core.BaseConstants;
import com.hand.hap.core.components.UserLoginInfoCollection;
import com.hand.hap.intergration.annotation.HapInbound;
import com.hand.hap.intergration.annotation.HapOutbound;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.exception.HapApiException;
import com.hand.hap.intergration.service.IHapApiService;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.system.controllers.BaseController;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class HapApiController extends BaseController implements BaseConstants {
    private final Logger logger = LoggerFactory.getLogger(HapApiController.class);
    private static final int INTERFACE_EXPIRE = 10;
    private static final int INTERFACE_NUM = 10;
    private static final Long INTERFACE_INTERVAL = Long.valueOf(500L);
    @Autowired
    IHapInterfaceHeaderService headerService;
    @Resource(name = "plsqlBean")
    IHapApiService plsqlService;
    @Resource(name = "restBean")
    IHapApiService restService;
    @Resource(name = "soapBean")
    IHapApiService soapService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private String redisCatalog = "hap:cache:interface:";

    public HapApiController() {
    }

    @ResponseBody
    @Timed
    //@HapOutbound
    //@HapInbound(apiName = "hap.invoke.apiname.interfacetranspond")
    @RequestMapping(value = {"/r/api"}, method = {RequestMethod.POST})
    public JSONObject sentRequest(HttpServletRequest request, @RequestBody(required = false) JSONObject params) throws Exception {
        String sysName = request.getParameter("sysName");
        String apiName = request.getParameter("apiName");
        this.logger.info("sysName:{}  apiName:{} ", sysName, apiName);
        this.logger.info("requestBody:{}", params);
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
        this.logger.info("return HmsInterfaceHeader:{}", hapInterfaceHeader);
        new HashMap();
        if(hapInterfaceHeader == null) {
            throw new HapApiException("error.request.url.not.found", "根据sysName和apiName没有找到数据");
        } else if(!hapInterfaceHeader.getRequestFormat().equals("raw")) {
            throw new HapApiException("error.requestFormat.not.support", "不支持的请求形式");
        } else {
            JSONObject json = null;
            if(hapInterfaceHeader.getInterfaceType().equals("REST")) {
                json = this.restService.invoke(hapInterfaceHeader, params);
            } else if(hapInterfaceHeader.getInterfaceType().equals("SOAP")) {
                json = this.soapService.invoke(hapInterfaceHeader, params);
            } else {
                if(!hapInterfaceHeader.getInterfaceType().equals("PLSQL")) {
                    throw new HapApiException("error.interfaceType.not.support", "不支持的接口类型");
                }

                json = this.plsqlService.invoke(hapInterfaceHeader, params);
            }

            return json;
        }
    }

    @ResponseBody
    @RequestMapping({"/api/user"})
    public Principal user(Principal principal) {
        return principal;
    }

    @RequestMapping(value = {"/api/public/xml_test"}, method = {RequestMethod.POST})
    @ResponseBody
    public String jf(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletInputStream servletInputStream = request.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(servletInputStream, "UTF-8"));
        String crmDataXml = FileCopyUtils.copyToString(reader);
        System.out.println(crmDataXml);
        return crmDataXml;
    }

    public Map<String, String> requestLimit(HttpServletRequest request) {
        Long lastTime = Long.valueOf(System.currentTimeMillis());
        HashMap map = new HashMap();
        String ip = UserLoginInfoCollection.getIpAddress(request);
        String sysName = request.getParameter("sysName");
        String apiName = request.getParameter("apiName");
        String redisKey = this.redisCatalog + ip + "_" + sysName + "_" + apiName;
        Object redisLastTime = this.redisTemplate.opsForHash().get(redisKey, "lastTime");
        if(redisLastTime != null) {
            long interval = lastTime.longValue() - Long.valueOf(redisLastTime.toString()).longValue();
            if(interval < INTERFACE_INTERVAL.longValue()) {
                map.put("result", "fail");
                map.put("msg", "Requests are too frequent");
            } else {
                Object num = this.redisTemplate.opsForHash().get(redisKey, "num");
                if(Integer.valueOf(num.toString()).intValue() >= 10) {
                    map.put("result", "fail");
                    map.put("msg", "10seconds to reach the maximum number of requests");
                } else {
                    map.put("result", "success");
                    this.redisTemplate.opsForHash().put(redisKey, "lastTime", lastTime + "");
                    this.redisTemplate.opsForHash().increment(redisKey, "num", 1L);
                }
            }
        } else {
            map.put("result", "success");
            this.redisTemplate.opsForHash().put(redisKey, "lastTime", lastTime + "");
            this.redisTemplate.opsForHash().put(redisKey, "num", "1");
            this.redisTemplate.expire(redisKey, 10L, TimeUnit.SECONDS);
        }

        return map;
    }
}
