package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Created by lrd on 2017/7/19.
 */
@UITag
public class HlsPage extends Grid implements HlsComponent{
    public static final String PROPERTITY_HLSPAGE = "hlsPage";
    public static final String PROPERTITY_HLSPAGEID = "hlspageid";
    public static final String PROPERTITY_TYPE = "gridType";
    public static final String PROPERTITY_HLSLASTIMGID = "lastImgId";
    public static final String PROPERTITY_HLSNEXTIMGID = "nextImgId";
    public static final String PROPERTITY_HLSTITLEIMG = "titleImg";
    public static final String PROPERTITY_HLSTITLE = "title";
    public static final String PROPERTITY_HLSPAGE_SIZE = "pageSize";
    public static final String PROPERTITY_HLSDATA_SOURCE = "hlsDataSource";
    public static final String PROPERTITY_COLUMNS = "columns";
    public static final String PROPERTITY_HLSTITLEADDID = "titleAddId";
//    public static final String PROPERTITY_HLSTITLESEARCHID = "titleSearchId";
//    public static final String PROPERTITY_HLSTITLESEARCHINPUTID = "titleSearchInputId";
    public static final String PROPERTITY_HLSTITLEQUERYID = "titleQueryId";
    public static final String PROPERTITY_HLSINPUTPLACEHOLDER = "inputPlaceholder";
    public static final String PROPERTITY_HLSLOCATEVENT = "locateEvent";
    public static final String PROPERTITY_HLSINPUTIMG = "inputImg";
    public static final String PROPERTITY_HLSITEMS = "items";
    public static final String PROPERTITY_HLSNEXTPAGEBUTTON = "nextPageButton";
    public static final String PROPERTITY_HLSLASTPAGEBUTTON = "lastPageButton";
    public static  final String PROPERTITY_COLOR="color";
    public static final String PROPERTITY_HLSWIDTH = "width";
    public static final String PROPERTITY_HLSBTNTYPE ="btnType";
    public static final String PROPERTITY_CLICK_FUNC = "clickFunc";
    public static final String PROPERTITY_IMG = "img";
    public static final String PROPERTITY_HLSTITLESTYLE = "titleStyle";
    public static final String PROPERTITY_HIDDENS= "hiddens";



    public String getTitleStyle() {
        return getPrototype().getString(PROPERTITY_HLSTITLESTYLE);
    }
    public String getLastPageButton(){
        return this.getPrototype().getString(PROPERTITY_HLSLASTPAGEBUTTON);
    }
    public String getColor(){return this.getPrototype().getString(PROPERTITY_COLOR);}

    public static HlsPage createInstance() {
        XMap view = new XMap(DEFAULT_TAG_PREFIX, DEFAULT_NAME_SPACE,
                PROPERTITY_HLSPAGE);
        HlsPage HlsPage = new HlsPage();
        HlsPage.initPrototype(view);
        return HlsPage;
    }

    public String getNextPageButton(){
        return this.getPrototype().getString(PROPERTITY_HLSNEXTPAGEBUTTON);

    }
    public Object getItems() {
        Items items = new Items();
        String paramMapArray = this.getPrototype().getString("items");
        XMap paramMapChild = this.getPrototype().getChild("items");
        ArrayList cList = new ArrayList();
        if(paramMapArray != null) {
            String[] var7 = paramMapArray.split(",");
            for(int var8 = 0; var8 < var7.length; ++var8) {
                var7[var8] = var7[var8].trim();
            }
            return var7;
        } else {
            if(paramMapChild != null) {
                List list = paramMapChild.getChildren();
                if(list != null) {
                    Iterator i = list.iterator();
                    while(i.hasNext()) {
                        XMap view = (XMap)i.next();
                        cList.add(ItemsMethod.parse(view));
                    }
                    return cList;
                }
            }
            return null;
        }
    }
    public void setItems(Items items) {
        XMap map = this.getPrototype().getChild("items");
        if(map == null) {
            map = this.getPrototype().createChild("h", "http://www.hand-china.com/hap", "items");
        }
        map.addChild(items.toXMap());
    }

    public String getClickFunc() {return this.getPrototype().getString(PROPERTITY_CLICK_FUNC);}
    public String getImg() {
        return this.getPrototype().getString(PROPERTITY_IMG);
    }
    public String getWidth() {
        return this.getPrototype().getString(PROPERTITY_HLSWIDTH);
    }
    public String getInputImg() {
        return this.getPrototype().getString(PROPERTITY_HLSINPUTIMG);
    }
    public String getLocateEvent() {
        return this.getPrototype().getString(PROPERTITY_HLSLOCATEVENT);
    }
    public String getInputPlaceHolder() {
        return getPrototype().getString(PROPERTITY_HLSINPUTPLACEHOLDER);
    }
    public String getHlsDataSource() {
        return getPrototype().getString(PROPERTITY_HLSDATA_SOURCE);
    }
    public String getPageSize() {
        return getPrototype().getString(PROPERTITY_HLSPAGE_SIZE);
    }
    public String getTitleQueryId() {
        return getPrototype().getString(PROPERTITY_HLSTITLEQUERYID);
    }
    public String getTitleAddId() {
        return getPrototype().getString(PROPERTITY_HLSTITLEADDID);
    }


    public String getLastImgId() {
        return getPrototype().getString(PROPERTITY_HLSLASTIMGID);
    }
    public String getNextImgId() {
        return getPrototype().getString(PROPERTITY_HLSNEXTIMGID);
    }
    public String getTitleImg() {
        return getPrototype().getString(PROPERTITY_HLSTITLEIMG);
    }
    public String getTitle() {
        return getPrototype().getString(PROPERTITY_HLSTITLE);
    }
    public String getBtnType(){
        return getPrototype().getString(PROPERTITY_HLSBTNTYPE);
    }
    public String getGridType(){return getPrototype().getString(PROPERTITY_TYPE);}
    public String getHiddens(){
        return getPrototype().getString(PROPERTITY_HIDDENS);
    }
    public void init(XMap view, ViewContext context) throws Exception {
        super.init(view, context);
        context.put(PROPERTITY_HLSTITLESTYLE,getTitleStyle());
        context.put(PROPERTITY_HLSDATA_SOURCE, getHlsDataSource());
        context.put(PROPERTITY_HLSCLASSNAME, getHlsClassName());
        context.put(PROPERTITY_HLSSTYLE, getHlsStyle());
        context.put(PROPERTITY_HLSLASTIMGID, getLastImgId());
        context.put(PROPERTITY_HLSNEXTIMGID, getNextImgId());
        context.put(PROPERTITY_HLSTITLEIMG, getTitleImg());
        context.put(PROPERTITY_HLSTITLE, getTitle());
        context.put(PROPERTITY_HLSINPUTPLACEHOLDER, getInputPlaceHolder());
        context.put(PROPERTITY_HLSTITLEQUERYID, getTitleQueryId());
        context.put(PROPERTITY_HLSTITLEADDID, getTitleAddId());
        context.put(PROPERTITY_HLSPAGE_SIZE, getPageSize());
        context.put(PROPERTITY_TYPE, getGridType());
        context.put(PROPERTITY_HLSNEXTPAGEBUTTON, getNextPageButton());
        context.put(PROPERTITY_HLSLASTPAGEBUTTON,getLastPageButton());
        context.put(PROPERTITY_COLOR,getColor());
        context.addJsonConfig("color",getColor());
        context.put(PROPERTITY_HLSWIDTH,getWidth());
//        context.put(PROPERTITY_HLSCHECKFLAG,getHlsCheckFlag());
        context.put(PROPERTITY_CLICK_FUNC,getClickFunc());
        context.put(PROPERTITY_IMG,getImg());
        context.addJsonConfig("locateEvent", getLocateEvent());
        context.addJsonConfig("pageSize",getPageSize());
        context.addJsonConfig("id", getId());
        context.addJsonConfig("titleImg", getTitleImg());
        context.addJsonConfig("columns", this.getColumns());
        context.addJsonConfig("items", this.getItems());
        context.addJsonConfig("inputImg", getInputImg());
        context.addJsonConfig("title", getTitle());
        context.addJsonConfig("titleStyle", getTitleStyle());
        setHlsBtn(context);
        setHiddens(context);
    }

    private void setHlsBtn(ViewContext context) {
        if (getBtnType() != null) {
            String[] datas = getBtnType().split(",");
            for (int i = 0; i < datas.length; i++) {
                String[] datas2 = datas[i].split(":");
                String btnType = datas2[0].trim().toUpperCase();
                context.put("BTN" + btnType, "Y");
                if(datas2.length==2) {
                    String btnFunction = datas2[1].trim();
                    context.put("BTF" + btnType,btnFunction );
                }
            }
        }
    }

    private void setHiddens(ViewContext context) {
        if (getHiddens() != null) {
            String[] datas = getHiddens().split(",");
            for (int i = 0; i < datas.length; i++) {
                context.put("HID"+datas[i].trim().toUpperCase(), "Y");
            }
        }
    }
    @Override
    public void hlsSetPropertity(Object key, Object value) {
        // TODO Auto-generated method stub
        super.setPropertity(key, value);
    }
}
