package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;
import org.apache.commons.collections.map.HashedMap;

import java.util.ArrayList;
import java.util.List;

/**
 * @author yang.gao01@hand-china.com
 */
@UITag
public class HlsGrid extends HlsInfoList {
    public static final String PROPERTITY_HLSGRID = "hlsGrid";
    public static final String PROPERTITY_TITLE = "title";
    public static final String PROPERTITY_WIDTH = "width";
    public static final String PROPERTITY_HEIGHT = "height";
    public static final String PROPERTITY_HLSCLASSNAME = "hlsClassName";
    public static final String PROPERTITY_HLSBTNTYPE = "hlsBtnType";
    public static final String PROPERTITY_COLUMNS = "columns";

    public void setHeight(String height) {
        setPropertity(PROPERTITY_TITLE, height);
    }

    public void setWidth(String width) {
        setPropertity(PROPERTITY_WIDTH, width);
    }

    public void setTitle(String title) {
        setPropertity(PROPERTITY_HEIGHT, title);
    }

    public void setHlsBtnType(String hlsBtnType) {
        setPropertity(PROPERTITY_HLSBTNTYPE, hlsBtnType.toUpperCase());
    }

    public void setHlsClassName(String hlsClassName) {
        setPropertity(PROPERTITY_HLSCLASSNAME, hlsClassName);
    }

    public String getHeight() {
        return getPrototype().getString(PROPERTITY_HEIGHT);
    }

    public String getHlsBtnType() {
        return getPrototype().getString(PROPERTITY_HLSBTNTYPE);
    }

    public String getWidth() {
        String width = getPrototype().getString(PROPERTITY_WIDTH);
        if (width == null) {
            width = "100%";
        }
        return width;
    }
    public String getTitle() {
        return getPrototype().getString(PROPERTITY_TITLE);
    }

    public String getHlsClassName() {
        return getPrototype().getString(PROPERTITY_HLSCLASSNAME);
    }

    public static String[] toArray(String value) {
        if (value != null) {
            String[] datas = value.split(",");
            for (int i = 0; i < datas.length; i++) {
                datas[i] = datas[i].trim();
            }
            return datas;
        }
        return null;
    }

    public Object getHlsColumns() {
        @SuppressWarnings("unchecked")
        List<Column> hlsColumns = (List<Column>) getColumns();
        if (getHlsBtnType() != null
                && (getHlsBtnType().indexOf("ADD") != -1 || getHlsBtnType()
                .indexOf("DELETE") != -1)) {
            String[] hlsBtnTypeArray = toArray(getHlsBtnType());
            GridColumn hlsAddColumn = new GridColumn();
            hlsAddColumn.setWidth("40");
            for (String hlsBtnType : hlsBtnTypeArray) {
                if ("DELETE".equalsIgnoreCase(hlsBtnType)) {
                    HashedMap hcmap = new HashedMap();
                    HashedMap hchmap = new HashedMap();
                    hcmap.put("class", "hlsgrid-add-btn-column");
                    hchmap.put("class", "hlsgrid-add-btn-header-column");
                    hlsAddColumn.setHeaderAttributes(hchmap);
                    hlsAddColumn.setAttributes(hcmap);
                    List<ColumnCommand> commands = new ArrayList<>();
                    @SuppressWarnings("unchecked")
                    ColumnCommand command = new ColumnCommand();
                    StringBuilder sb1 = new StringBuilder();
                    sb1.append("<a class=\"hlsgrid-btn-delete\" >");
                    sb1.append("<i class=\"fa fa-minus-circle hlsgridbox-btn-delete-i\"></i>");
                    sb1.append("</a>");
                    command.setTemplate(sb1.toString());
                    commands.add(command);
                    hlsAddColumn.setCommand(commands);
                }
            }
            hlsColumns.add(hlsColumns.size(), hlsAddColumn);
        }
        return hlsColumns;
    }

    public String getHlsStyle() {
        String style = this.getPrototype().getString("style");
        style = "margin-bottom:30px;"+style;
        return style;
    }

    public static HlsGrid createInstance() {
        XMap view = new XMap(DEFAULT_TAG_PREFIX, DEFAULT_NAME_SPACE,
                PROPERTITY_HLSGRID);
        HlsGrid HlsGrid = new HlsGrid();
        HlsGrid.initPrototype(view);
        return HlsGrid;
    }

    public void init(XMap view, ViewContext context) throws Exception {
        super.init(view, context);
        context.put(PROPERTITY_TITLE, getTitle());
        context.put(PROPERTITY_HEIGHT, getHeight());
        context.put(PROPERTITY_WIDTH, getWidth());
        context.put(PROPERTITY_HLSCLASSNAME, getHlsClassName());
        context.put(PROPERTITY_HLSBTNTYPE, getHlsBtnType());
        context.addJsonConfig(PROPERTITY_COLUMNS, getHlsColumns());
        if(getAutoResize()!=null&&getAutoResize()==true){
            context.put("style", getHlsStyle());
        }
    }
}
