package com.hand.app.ocr.service.impl;

import com.hand.app.ocr.service.IOcrService;
import com.hand.app.ocr.util.HttpClientPost;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.entity.mime.MultipartEntity;
import org.springframework.stereotype.Service;
import java.io.File;
import org.apache.http.entity.mime.content.FileBody;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;


/**
 * Created by Think-PC on 2018/9/12.
 */
@Service
public class OcrServiceImpl implements IOcrService {

    /**
     * 识别银行卡图片上的卡号和相关信息
     */
    public JSONObject ocrBankcard(String filePath) throws Exception{
        JSONObject json = null;
        String post_url = "https://v2-auth-api.visioncloudapi.com/ocr/bankcard/stateless";
        FileBody fileBody = new FileBody(new File(filePath));
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("image_file", fileBody);
        json = HttpClientPost.post(post_url,entity);
        return json;
    }
    /**
     * 识别静态身份证图片上的文字信息
     */
    public JSONObject ocrIdcard(String filePath) throws Exception{
        JSONObject json = null;
        String post_url = "https://v2-auth-api.visioncloudapi.com/ocr/idcard/stateless";
        FileBody fileBody = new FileBody(new File(filePath));
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("image_file", fileBody);
        json = HttpClientPost.post(post_url,entity);
        return json;
    }
    /**
     * 识别营业执照上的文字信息
     */
    public JSONObject ocrBusinessLicense(String filePath) throws Exception{
        JSONObject json = null;
        String post_url = "https://v2-auth-api.visioncloudapi.com/ocr/business_license/stateless";
        FileBody fileBody = new FileBody(new File(filePath));
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("license_image", fileBody);
        json = HttpClientPost.post(post_url,entity);
        return json;
    }
    /**
     * 识别组织机构代码上的文字信息
     */
    public JSONObject ocrOrganizationCode(String filePath) throws Exception{
        JSONObject json = null;
        String post_url = "https://v2-auth-api.visioncloudapi.com/ocr/organization_code/stateless";
        FileBody fileBody = new FileBody(new File(filePath));
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("organization_image", fileBody);
        json = HttpClientPost.post(post_url,entity);
        return json;
    }
    /**
     * 识别行驶证上的文字信息
     */
    public JSONObject ocrVehicleLicense(String filePath) throws Exception{
        JSONObject json = null;
        String post_url = "https://v2-auth-api.visioncloudapi.com/ocr/vehicle_license/stateless";
        FileBody fileBody = new FileBody(new File(filePath));
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("image_file", fileBody);
        json = HttpClientPost.post(post_url,entity);
        return json;
    }
    /**
     * 识别驾驶证上的文字信息
     */
    public JSONObject ocrDrivingLicense(String filePath) throws Exception{
        JSONObject json = null;
        String post_url = "https://v2-auth-api.visioncloudapi.com/ocr/driving_license/stateless";
        FileBody fileBody = new FileBody(new File(filePath));
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("image_file", fileBody);
        json = HttpClientPost.post(post_url,entity);
        return json;
    }
    /**
      * 识别图片上的文字信息
      */
    public JSONObject ocrGeneral(String filePath) throws Exception{
        JSONObject json = null;
        String post_url = "https://v2-auth-api.visioncloudapi.com/ocr/general/stateless";
        FileBody fileBody = new FileBody(new File(filePath));
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("image_file", fileBody);
        json = HttpClientPost.post(post_url,entity);
        return json;
    }
    /**
      * 识别静态身份证图像上的文字信息，并输出一张关键信息打码后的身份证图片
      */
    public JSONObject ocrIdcardMask(String filePath) throws Exception{
        JSONObject json = null;
        String post_url = "https://v2-auth-api.visioncloudapi.com/ocr/idcard_mask/stateless";
        FileBody fileBody = new FileBody(new File(filePath));
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("image_file", fileBody);
        json = HttpClientPost.post(post_url,entity);
        return json;
    }
    /**
      * 识别增值税发票上的文字信息
      */
    public JSONObject ocrVatInvoice(String filePath) throws Exception{
        JSONObject json = null;
        String post_url = "https://v2-auth-api.visioncloudapi.com/ocr/vat_invoice/stateless";
        FileBody fileBody = new FileBody(new File(filePath));
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("image_file", fileBody);
        json = HttpClientPost.post(post_url,entity);
        return json;
    }
    /**
      * 识别车牌位置，颜色及车牌号
      */
    public JSONObject ocrLicensePlate(String filePath) throws Exception{
        JSONObject json = null;
        String post_url = "https://v2-auth-api.visioncloudapi.com/ocr/license_plate/stateless";
        FileBody fileBody = new FileBody(new File(filePath));
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("image_file", fileBody);
        json = HttpClientPost.post(post_url,entity);
        return json;
    }
    /**
      * 识别医疗票据上的文字信息
      */
    public JSONObject ocrMedicalDoc(String filePath) throws Exception{
        JSONObject json = null;
        String post_url = "https://v2-auth-api.visioncloudapi.com/ocr/medical_doc/stateless";
        FileBody fileBody = new FileBody(new File(filePath));
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("image_file", fileBody);
        json = HttpClientPost.post(post_url,entity);
        return json;
    }
    /**
      * 识别机动车统一销售发票上的文字信息
      */
    public JSONObject ocrCarSalesInvoice(String filePath) throws Exception{
        JSONObject json = null;
        String post_url = "https://v2-auth-api.visioncloudapi.com/ocr/car_sales_invoice/stateless";
        FileBody fileBody = new FileBody(new File(filePath));
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("image_file", fileBody);
        json = HttpClientPost.post(post_url,entity);
        return json;
    }
    /**
      * 识别快递单图片上的文字信息
      */
    public JSONObject ocrExpressReceipt(String filePath) throws Exception{
        JSONObject json = null;
        String post_url = "https://v2-auth-api.visioncloudapi.com/ocr/express_receipt/stateless";
        FileBody fileBody = new FileBody(new File(filePath));
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("express_image", fileBody);
        json = HttpClientPost.post(post_url,entity);
        return json;
    }


    /**
     * 比对上传视频是否为身份证对应个体
     * path 本地生成的视频路径
     * name姓名
     * idnumber身份证号码
     */
    public JSONObject silentDetection(String path,String name,String idnumber) throws Exception{
        JSONObject json;
        String post_url = "https://v2-auth-api.visioncloudapi.com/identity/silent_idnumber_verification/stateless";
        StringBody user_name = new StringBody(name,Charset.forName("UTF-8"));
        StringBody number = new StringBody(idnumber);
        FileBody fileBody = new FileBody(new File(path));
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("name", user_name);
        entity.addPart("idnumber", number);
        entity.addPart("video_file", fileBody);
        json = HttpClientPost.post(post_url,entity);
        return json;
    }
}
