package com.hand.app.ocr.controllers;

import com.codahale.metrics.annotation.Timed;
import com.hand.app.ocr.service.IOcrService;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.exception.HapApiException;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.app.hms.service.impl.PureNetUtilImpl;
import com.alibaba.fastjson.JSONObject;
import com.hand.hap.system.service.ISysConfigService;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;


import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.*;

/**
 * Created on 2018/9/12.
 */
@Controller
@RequestMapping(value = "/r/api")
public class OcrStatelessController extends BaseController {
    private Logger logger = LoggerFactory.getLogger(OcrStatelessController.class);

    @Autowired
    IOcrService ocrService;

    @Autowired
    ISysConfigService sysConfigService;

    @RequestMapping(value = "/upload/ocr/stateless", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject ocrIdCardByUpload(HttpServletRequest request)
            throws HapApiException, IOException {
        String apiName = request.getParameter("ocrType");
        JSONObject json = new JSONObject();
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            boolean isMultipart = ServletFileUpload.isMultipartContent(request);
            if (!isMultipart) {
                json.put("code", "E");
                json.put("error", "不支持的文件类型");
            }
            if (request instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest req = (MultipartHttpServletRequest) request;
                Map<String, MultipartFile> fileMap = req.getFileMap();
                if (fileMap != null) {
                    Iterator<Map.Entry<String, MultipartFile>> iterator = fileMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, MultipartFile> next = iterator.next();
                        String fileKey = next.getKey();
                        MultipartFile filePart = next.getValue();
                        Long size = filePart.getSize();
                        inputStream = filePart.getInputStream();
                        String fileName = UUID.randomUUID().toString().replace("-", "").toUpperCase();

                        //生成文件进入用于文件预览
                        String tomcatPath = sysConfigService.getConfigValue("OCR.PICTURE.PATH");
                        File file = new File(tomcatPath);
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        tomcatPath += File.separator + fileName;
                        outputStream = new FileOutputStream(tomcatPath);
                        int len = -1;
                        byte[] bytes = new byte[1024];
                        while ((len = inputStream.read(bytes)) != -1) {
                            outputStream.write(bytes, 0, len);//写入
                        }
                        outputStream.flush();
                        outputStream.close();
                        inputStream.close();
                        logger.info(tomcatPath);
                        //识别银行卡图片上的卡号和相关信息
                        if(apiName.equals("bankcard")){
                            json = ocrService.ocrBankcard(tomcatPath);
                        }
                        //识别静态身份证图片上的文字信息
                        else if(apiName.equals("idCard")){
                            json = ocrService.ocrIdcard(tomcatPath);
                        }
                        //识别营业执照上的文字信息
                        else if(apiName.equals("businessLicense")){
                            json = ocrService.ocrBusinessLicense(tomcatPath);
                        }
                        //识别驾驶证上的文字信息
                        else if(apiName.equals("drivingLicense")){
                            json = ocrService.ocrDrivingLicense(tomcatPath);
                        }
                        //识别组织机构代码上的文字信息
                        else if(apiName.equals("organizationCode")){
                            json = ocrService.ocrOrganizationCode(tomcatPath);
                        }
                        //识别行驶证上的文字信息
                        else if(apiName.equals("vehicleLicense")){
                            json = ocrService.ocrVehicleLicense(tomcatPath);
                        }
                        //识别图片上的文字信息
                        else if(apiName.equals("general")){
                            json = ocrService.ocrGeneral(tomcatPath);
                        }
                        //识别静态身份证图像上的文字信息，并输出一张关键信息打码后的身份证图片
                        else if(apiName.equals("idcardMask")){
                            json = ocrService.ocrIdcardMask(tomcatPath);
                        }
                        //识别增值税发票上的文字信息
                        else if(apiName.equals("vatInvoice")){
                            json = ocrService.ocrVatInvoice(tomcatPath);
                        }
                        //识别快递单图片上的文字信息
                        else if(apiName.equals("expressReceipt")){
                            json = ocrService.ocrExpressReceipt(tomcatPath);
                        }
                        //识别机动车统一销售发票上的文字信息
                        else if(apiName.equals("carSalesInvoice")){
                            json = ocrService.ocrCarSalesInvoice(tomcatPath);
                        }
                        //识别医疗票据上的文字信息
                        else if(apiName.equals("medicalDoc")){
                            json = ocrService.ocrMedicalDoc(tomcatPath);
                        }
                        //识别车牌位置，颜色及车牌号
                        else if(apiName.equals("licensePlate")){
                            json = ocrService.ocrLicensePlate(tomcatPath);
                        }
                        else{
                            json.put("code", "E");
                            json.put("error", "没有对应类型的OCR接口");
                        }

                    }
                }
            }

        } catch (Exception e) {
            logger.info(e.toString());
            json.put("code", "E");
            json.put("error", e.getMessage());
        } finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return json;
    }

    @RequestMapping(value = "/ocr/bankcard/stateless", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject ocrBankcard(HttpServletRequest requests, @RequestBody(required = false) JSONObject params) throws Exception {
        logger.info("requestBody:{}", params);
        String imgPath = params.getString("imgPath");
        return ocrService.ocrBankcard(imgPath);
    }

    @RequestMapping(value = "/ocr/idcard/stateless", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject ocrIdCard(HttpServletRequest requests, @RequestBody(required = false) JSONObject params) throws Exception {
        logger.info("requestBody:{}", params);
        String imgPath = params.getString("imgPath");
        return ocrService.ocrIdcard(imgPath);
    }

    @RequestMapping(value = "/ocr/business_license/stateless", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject ocrBusinessLicense(HttpServletRequest requests, @RequestBody(required = false) JSONObject params) throws Exception {
        logger.info("requestBody:{}", params);
        String imgPath = params.getString("imgPath");
        return ocrService.ocrBusinessLicense(imgPath);
    }

    @RequestMapping(value = "/ocr/driving_license/stateless", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject ocrDrivingLicense(HttpServletRequest requests, @RequestBody(required = false) JSONObject params) throws Exception {
        logger.info("requestBody:{}", params);
        String imgPath = params.getString("imgPath");
        return ocrService.ocrDrivingLicense(imgPath);
    }

    @RequestMapping(value = "/ocr/organization_code/stateless", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject ocrOrganizationCode(HttpServletRequest requests, @RequestBody(required = false) JSONObject params) throws Exception {
        logger.info("requestBody:{}", params);
        String imgPath = params.getString("imgPath");
        return ocrService.ocrOrganizationCode(imgPath);
    }

    @RequestMapping(value = "/ocr/vehicle_license/stateless", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject ocrVehicleLicense(HttpServletRequest requests, @RequestBody(required = false) JSONObject params) throws Exception {
        logger.info("requestBody:{}", params);
        String imgPath = params.getString("imgPath");
        return ocrService.ocrVehicleLicense(imgPath);
    }

    @RequestMapping(value = "/ocr/general/stateless", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject ocrGeneral(HttpServletRequest requests, @RequestBody(required = false) JSONObject params) throws Exception {
        logger.info("requestBody:{}", params);
        String imgPath = params.getString("imgPath");
        return ocrService.ocrGeneral(imgPath);
    }

    @RequestMapping(value = "/ocr/idcard_mask/stateless", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject ocrIdcardMask(HttpServletRequest requests, @RequestBody(required = false) JSONObject params) throws Exception {
        logger.info("requestBody:{}", params);
        String imgPath = params.getString("imgPath");
        return ocrService.ocrIdcardMask(imgPath);
    }

    @RequestMapping(value = "/ocr/vat_invoice/stateless", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject ocrVatInvoice(HttpServletRequest requests, @RequestBody(required = false) JSONObject params) throws Exception {
        logger.info("requestBody:{}", params);
        String imgPath = params.getString("imgPath");
        return ocrService.ocrVatInvoice(imgPath);
    }

    @RequestMapping(value = "/ocr/express_receipt/stateless", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject ocrExpressReceipt(HttpServletRequest requests, @RequestBody(required = false) JSONObject params) throws Exception {
        logger.info("requestBody:{}", params);
        String imgPath = params.getString("imgPath");
        return ocrService.ocrExpressReceipt(imgPath);
    }

    @RequestMapping(value = "/ocr/car_sales_invoice/stateless", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject ocrCarSalesInvoice(HttpServletRequest requests, @RequestBody(required = false) JSONObject params) throws Exception {
        logger.info("requestBody:{}", params);
        String imgPath = params.getString("imgPath");
        return ocrService.ocrCarSalesInvoice(imgPath);
    }

    @RequestMapping(value = "/ocr/medical_doc/stateless", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject ocrMedicalDoc(HttpServletRequest requests, @RequestBody(required = false) JSONObject params) throws Exception {
        logger.info("requestBody:{}", params);
        String imgPath = params.getString("imgPath");
        return ocrService.ocrMedicalDoc(imgPath);
    }

    @RequestMapping(value = "/ocr/license_plate/stateless", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject ocrLicensePlate(HttpServletRequest requests, @RequestBody(required = false) JSONObject params) throws Exception {
        logger.info("requestBody:{}", params);
        String imgPath = params.getString("imgPath");
        return ocrService.ocrLicensePlate(imgPath);
    }

    @RequestMapping(value = "/app/silentDetection", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject ocrLivenessImageVerification(HttpServletRequest request){
        JSONObject json = new JSONObject();
        String name = request.getParameter("name");
        String idnumber = request.getParameter("idnumber");
        try {
            boolean isMultipart = ServletFileUpload.isMultipartContent(request);
            if (!isMultipart) {
                json.put("error", "不支持的文件类型");
            }
            if (request instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest req = (MultipartHttpServletRequest) request;
                Map<String, MultipartFile> fileMap = req.getFileMap();
                if (fileMap != null) {
                    Iterator<Map.Entry<String, MultipartFile>> iterator = fileMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, MultipartFile> next = iterator.next();
                        MultipartFile filePart = next.getValue();
                        InputStream inputStream = filePart.getInputStream();
                        String fileName = UUID.randomUUID().toString().replace("-", "").toUpperCase() + ".mp4";

                        //生成文件进入用于文件预览
                        String path = sysConfigService.getConfigValue("OCR.PICTURE.PATH");
                        File file = new File(path);
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        path += File.separator + fileName;
                        OutputStream outputStream = new FileOutputStream(path);
                        int len;
                        byte[] bytes = new byte[1024];
                        while ((len = inputStream.read(bytes)) != -1) {
                            outputStream.write(bytes, 0, len);//写入
                        }
                        outputStream.flush();
                        outputStream.close();
                        inputStream.close();
                        json = ocrService.silentDetection(path,name,idnumber);
                    }
                }
            }
        } catch (Exception e) {
            json.put("error", e.getMessage());
        }
        return json;
    }
}
