//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.hand.app.esignHclc.utils;

import com.baidu.aip.ocr.AipOcr;
import com.hand.app.esign.utils.SignUtils;
import com.hand.app.esignHclc.dto.SignUserInfoHclc;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: lsy
 * Date: 2020/2/24
 * Time: 9:08
 */

public class SignHclcUtils {

    //设置百度图片识别APPID/AK/SK
    public static final String APP_ID = "19796608";
    public static final String API_KEY = "jbUF3K70pQIGK2HcLyRqZfLy";
    public static final String SECRET_KEY = "YtRDMZvCX9xqCwwqqDDBnInC0FAGoSWw";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static Logger logger = LoggerFactory.getLogger(SignHclcUtils.class);

    public SignHclcUtils() {
    }

    /***
     * 项目初始化 使用到的接口;
     * @param info
     * @param appId
     * @param secret
     */
    public static SignUserInfoHclc initProject(SignUserInfoHclc info, String appId, String secret, String notifyUrl) {
        info.setAppId(appId);
        info.setSecret(secret);
        info.setNotifyUrl(notifyUrl);
        return info;
    }


    /**
     * 向指定URL发送POST方法的请求
     *
     * @param urls   发送请求的URL
     * @param params 请求参数，请求参数应该是 JSON 的形式。
     * @return URL 所代表远程资源的响应结果
     */
    public String postString(String urls, JSONObject params, Map<String, String> headInfo, String contentType) {
        HttpClient client = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(urls);
        String result = "";

        try {

            if (Objects.nonNull(headInfo)) {
                for (Map.Entry<String, String> entry : headInfo.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }

            if (APPLICATION_JSON.equalsIgnoreCase(contentType)) {
                String json = params.toString();
                StringEntity s = new StringEntity(json, "utf-8");
                s.setContentEncoding(new BasicHeader("Content-Type", APPLICATION_JSON));
                post.setHeader("Content-Type", APPLICATION_JSON);
                post.setEntity(s);
            } else if (APPLICATION_FORM_URLENCODED.equalsIgnoreCase(contentType)) {
                List<NameValuePair> nameValuePairList = new ArrayList<NameValuePair>();
                for (String key : params.keySet()) {
                    nameValuePairList.add(new BasicNameValuePair(key, Objects.nonNull(params.get(key)) ? params.get(key).toString() : ""));
                }
                UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(nameValuePairList, "utf-8");
                formEntity.setContentType("application/x-www-form-urlencoded; charset=UTF-8");
                post.setEntity(formEntity);
            }

            HttpResponse httpResponse = client.execute(post);
            InputStream inStream = httpResponse.getEntity().getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, "utf-8"));
            StringBuilder strber = new StringBuilder();
            String line = null;

            while ((line = reader.readLine()) != null) {
                strber.append(line + "\n");
            }

            inStream.close();
            result = strber.toString();
            if (!urls.contains("v2/identity/auth/api/ocr/license")) {
                if (httpResponse.getStatusLine().getStatusCode() == 200) {
                    logger.info("请求服务器成功, urls ={},params ={} ,contentType ={} ,result ={}", urls, params.toString(), contentType, result);
                } else {
                    logger.info("请求服务端失败, urls ={},params ={} ,contentType ={} ,result ={}", urls, params.toString(), contentType, result);
                }
            }else{
                if (httpResponse.getStatusLine().getStatusCode() == 200) {
                    logger.info("请求服务器成功, urls ={},contentType ={} ,result ={}", urls, contentType, result);
                } else {
                    logger.info("请求服务端失败, urls ={},contentType ={} ,result ={}", urls, contentType, result);
                }
            }

            return result;
        } catch (Exception var12) {
            var12.printStackTrace();
            throw new RuntimeException(var12);
        }
    }

//    public String postFormUrlEncoded(String url, JSONObject params, Map<String, String> headInfo) {
//        HttpClient httpClient = HttpClientBuilder.create().build();
//        HttpPost post = new HttpPost(url);
//        String result = "";
//        try {
//            if (Objects.nonNull(headInfo)) {
//                for (Map.Entry<String, String> entry : headInfo.entrySet()) {
//                    post.setHeader(entry.getKey(), entry.getValue());
//                }
//            }
//            if (params != null) {
//                List<NameValuePair> nameValuePairList = new ArrayList<NameValuePair>();
//                for (String key : params.keySet()) {
//                    nameValuePairList.add(new BasicNameValuePair(key, params.get(key).toString()));
//                }
//                UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(nameValuePairList, "utf-8");
//                formEntity.setContentType("application/x-www-form-urlencoded; charset=UTF-8");
//                post.setEntity(formEntity);
//            }
//
//            HttpResponse httpResponse = httpClient.execute(post);
//            InputStream inStream = httpResponse.getEntity().getContent();
//            BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, "utf-8"));
//            StringBuilder strber = new StringBuilder();
//            String line = null;
//
//            while ((line = reader.readLine()) != null) {
//                strber.append(line + "\n");
//            }
//
//            inStream.close();
//            result = strber.toString();
//            if (httpResponse.getStatusLine().getStatusCode() == 200) {
//                System.out.println("请求服务器成功");
//            } else {
//                System.out.println("请求服务端失败");
//            }
//
//            return result;
//        } catch (Exception var12) {
//            var12.printStackTrace();
//            throw new RuntimeException(var12);
//        }
//    }

    public String getJSON(String url) {
        try {
            URL thisurl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection) thisurl.openConnection();
            connection.connect();
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            StringBuilder sb = new StringBuilder();

            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }

            br.close();
            connection.disconnect();
            return sb.toString();
        } catch (Exception var7) {
            var7.printStackTrace();
            return null;
        }
    }


    public String aes(String key, String res) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance("AES");
            byte[] keyBytes = key.getBytes("utf-8");
            kg.init(128, new SecureRandom(keyBytes));
            SecretKey sk = kg.generateKey();
            SecretKeySpec sks = new SecretKeySpec(sk.getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, sks);
            byte[] resBytes = res.getBytes("utf-8");
            String data = this.parseByte2HexStr(cipher.doFinal(resBytes));
            return data;
        } catch (Exception var10) {
            var10.printStackTrace();
            throw new RuntimeException(var10);
        }
    }

    private String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();

        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 255);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }

            sb.append(hex.toUpperCase());
        }

        return sb.toString();
    }

    public String signString(String secKey, String data) {
        try {
            String srcStr = "secKey=" + secKey + "&data=" + data;
            SecretKeySpec keySpec = new SecretKeySpec(secKey.getBytes("UTF-8"), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(keySpec);
            byte[] signBytes = mac.doFinal(srcStr.getBytes("UTF-8"));
            String appSec = Base64.encodeBase64String(signBytes);
            return appSec;
        } catch (Exception var8) {
            var8.printStackTrace();
            throw new RuntimeException(var8);
        }
    }

    /**
     * 向指定URL发送GET方法的请求
     *
     * @param url   发送请求的URL
     * @param param 请求参数，请求参数应该是 name1=value1&name2=value2 的形式。
     * @return URL 所代表远程资源的响应结果
     */
    public static String getStr(String url, String param, Map<String, String> headInfo) {
        String result = "";
        BufferedReader in = null;
        try {
            String urlNameString = url + "?" + param;
            URL realUrl = new URL(urlNameString);
            // 打开和URL之间的连接
            URLConnection connection = realUrl.openConnection();
            // 设置通用的请求属性
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");

            if (Objects.nonNull(headInfo)) {
                for (Map.Entry<String, String> entry : headInfo.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }

            // 建立实际的连接
            connection.connect();
            // 获取所有响应头字段
            Map<String, List<String>> map = connection.getHeaderFields();
            // 遍历所有的响应头字段
//            for (String key : map.keySet()) {
//                System.out.println(key + "--->" + map.get(key));
//            }
            // 定义 BufferedReader输入流来读取URL的响应
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String line;
            while ((line = in.readLine()) != null) {
                result += line;
            }
        } catch (Exception e) {
            System.out.println("发送GET请求出现异常！" + e);
            e.printStackTrace();
        }
        // 使用finally块来关闭输入流
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (Exception e2) {
                e2.printStackTrace();
            }
        }

        logger.info("请求服务端成功, url ={},param ={}", url, param);

        return result;
    }

    /***
     * 获取鉴权Token;
     * @param faceApiUrl
     */
    public String getFaceApiToken(String faceApiUrl, String appId, String secret) {
        String token = null;
        try {
            SignHclcUtils signHclcUtils = new SignHclcUtils();
            String param = "appId=" + appId + "&secret=" + secret + "&grantType=client_credentials";
            String stringResult = signHclcUtils.getStr(faceApiUrl, param, null);
            JSONObject json2 = JSONObject.parseObject(stringResult);
            if ("0".equalsIgnoreCase(json2.getString("code"))) {
                JSONObject data = json2.getJSONObject("data");
                token = data.getString("token");
            }
            return token;
        } catch (Exception var8) {
            var8.printStackTrace();
            return token;
        }
    }

    /***
     * orc身份证识别;
     * @param image
     */
    public JSONObject idcard(byte[] image) {
        // 传入可选参数调用接口
        AipOcr client = new AipOcr(APP_ID, API_KEY, SECRET_KEY);
        HashMap<String, String> options = new HashMap<String, String>();

        //是否检测图像朝向，默认不检测，即：false。朝向是指输入图像是正常方向、逆时针旋转90/180/270度。可选值包括:- true：检测朝向；- false：不检测朝向。
        options.put("detect_direction", "true");
        //是否开启身份证风险类型(身份证复印件、临时身份证、身份证翻拍、修改过的身份证)功能，默认不开启，即：false。可选值:true-开启；false-不开启
        options.put("detect_risk", "false");
        //front：身份证含照片的一面；back：身份证带国徽的一面
        String idCardSide = "front";

        // 参数为本地图片路径
        org.json.JSONObject res = client.idcard(image, idCardSide, options);

        JSONObject jsonObject = new JSONObject();
        if (Objects.nonNull(res.get("words_result").toString())) {
            jsonObject = getJsonResult(res);
        }

        logger.info("OCR身份证识别成功, result ={}", jsonObject.toString());
        return jsonObject;
    }

    /***
     * orc银行卡识别;
     * @param image
     */
    public JSONObject bankcard(byte[] image) {
        // 传入可选参数调用接口
        AipOcr client = new AipOcr(APP_ID, API_KEY, SECRET_KEY);
        HashMap<String, String> options = new HashMap<String, String>();

        // 参数为本地图片路径
        org.json.JSONObject res = client.bankcard(image, options);

        JSONObject jsonObject = new JSONObject();
        if (Objects.nonNull(res.get("result"))) {
            jsonObject.put("bank_card_number",res.getJSONObject("result").getString("bank_card_number").replace(" ",""));
            jsonObject.put("bank_name",res.getJSONObject("result").getString("bank_name"));
            jsonObject.put("bank_card_type",res.getJSONObject("result").getLong("bank_card_type"));
        }

        logger.info("OCR身份证识别成功, result ={}", jsonObject.toString());
        return jsonObject;
    }

    /***
     * 营业执照识别;
     * @param image
     */
    public JSONObject businessLicense(byte[] image) {
        // 传入可选参数调用接口
        AipOcr client = new AipOcr(APP_ID, API_KEY, SECRET_KEY);
        HashMap<String, String> options = new HashMap<String, String>();

        // 参数为本地图片路径
        org.json.JSONObject res = client.businessLicense(image, options);

        JSONObject jsonObject = new JSONObject();
        if (Objects.nonNull(res.get("words_result").toString())) {
            jsonObject = getJsonResult(res);
        }

        if (Objects.nonNull(jsonObject.getString("社会信用代码"))) {
            jsonObject.put("社会信用代码", jsonObject.getString("社会信用代码").substring(0, 18));
        }
        logger.info("OCR营业执照识别识别成功, result ={}", jsonObject.toString());
        return jsonObject;
    }

    private JSONObject getJsonResult(org.json.JSONObject res) {
        JSONObject jsonObject = new JSONObject();
        JSONObject jsonObjectRes = JSONObject.parseObject(res.get("words_result").toString());
        for (String str : jsonObjectRes.keySet()) {
            String value = "";
            if (!"".equalsIgnoreCase(jsonObjectRes.getString(str)) && Objects.nonNull(jsonObjectRes.getString(str))) {
                value = jsonObjectRes.getJSONObject(str).getString("words");
                jsonObject.put(str, value);
            }
        }
        return jsonObject;

    }


}
