package com.hand.app.esignHclc.controllers;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.esignHclc.dto.SignUserAttachInfo;
import com.hand.app.esignHclc.dto.SignUserInfoHclc;
import com.hand.app.esignHclc.dto.SignUserFaceHclc;
import com.hand.app.esignHclc.dto.SignUserInfoHclcHis;
import com.hand.app.esignHclc.mapper.SignInfoHclcMapper;
import com.hand.app.esignHclc.mapper.SignUserInfoHclcHisMapper;
import com.hand.app.esignHclc.service.*;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import hls.support.core.wechat.formbean.AttachmentInfo;
import com.hand.hap.system.dto.ResponseData;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: lsy
 * Date: 2020/2/24
 * Time: 9:08
 */
@Controller
@RequestMapping(value = {"/r/api", "/"})
public class SignHclcController extends BaseController {
    @Autowired
    private ISignInfoHclcService signHclcService;
    @Autowired
    private IOrganSignInfoHclcService organSignHclcService;
    @Autowired
    private ISignInfoHclcFaceService signInfoHclcFaceService;
    @Autowired
    private ISignUserInfoHclcHisService signUserInfoHclcHisService;
    @Autowired
    private SignInfoHclcMapper signInfoHclcMapper;
    @Autowired
    private SignUserInfoHclcHisMapper signUserInfoHclcHisMapper;
    @Autowired
    private ISignUserAttachInfoService iSignUserAttachInfoService;


    /**
     * 根据openid获取用户信息
     *
     * @param request
     * @param dto     根据openid获取用户信息
     * @return responseData
     */
    @ResponseBody
    @RequestMapping(value = "/sign/info/hclc/query/by/openid")
    public ResponseData query(HttpServletRequest request, SignUserInfoHclc dto) {
        IRequest requestContext = createRequestContext(request);
        List<SignUserInfoHclc> signInfoHclcs = new ArrayList<>();
        String openId = dto.getOpenId();
        SignUserInfoHclc signInfoHclc = signHclcService.selectByPrimaryKey(requestContext, dto);

        if (Objects.nonNull(signInfoHclc)) {
            //设置用户信息是否为历史备份信息
            signInfoHclc.setHistoryFlag("N");

            //获取人脸核验状态
            if (Objects.nonNull(signInfoHclc.getFaceAuthId())) {
                SignUserFaceHclc signInfoHclcFace = new SignUserFaceHclc();
                signInfoHclcFace.setAuthId(signInfoHclc.getFaceAuthId());
                signInfoHclcFace = signInfoHclcFaceService.selectByPrimaryKey(requestContext, signInfoHclcFace);
                signInfoHclc.setFaceAuthStatus(signInfoHclcFace.getAuthStatus());
            }

            //获取机构对公打款状态
            if (Objects.nonNull(signInfoHclc.getOrgAuthId())) {
                SignUserFaceHclc signInfoHclcFace = new SignUserFaceHclc();
                signInfoHclcFace.setAuthId(signInfoHclc.getOrgAuthId());
                signInfoHclcFace = signInfoHclcFaceService.selectByPrimaryKey(requestContext, signInfoHclcFace);
                signInfoHclc.setOrgAuthStatus(signInfoHclcFace.getAuthStatus());
            }

            SignUserAttachInfo signUserAttachInfo = new SignUserAttachInfo();
            signUserAttachInfo.setOpenId(signInfoHclc.getOpenId());
            List<SignUserAttachInfo> signUserAttachInfos = new ArrayList<>();
            //身份证附件Id
            {
                signUserAttachInfo.setAttachmentType("app_file_id_card");
                signUserAttachInfos = iSignUserAttachInfoService.select(requestContext, signUserAttachInfo, 1, 1);
                if (signUserAttachInfos.size() > 0 && Objects.nonNull(signUserAttachInfos.get(0).getAttachmentIdHclc())) {
                    signInfoHclc.setAttachmentId(signUserAttachInfos.get(0).getAttachmentIdHclc().toString());
                }
            }

            //营业执照附件Id
            {
                signUserAttachInfo.setAttachmentType("app_file_bus_lic");
                signUserAttachInfos = iSignUserAttachInfoService.select(requestContext, signUserAttachInfo, 1, 1);
                if (signUserAttachInfos.size() > 0 && Objects.nonNull(signUserAttachInfos.get(0).getAttachmentIdHclc())) {
                    signInfoHclc.setOrgAttachmentId(signUserAttachInfos.get(0).getAttachmentIdHclc().toString());
                }
            }
        } else {
            //查询是否存在历史注册信息，用于合同查看、文件下载
            List<SignUserInfoHclcHis> userInfoHclcHisList = new ArrayList<>();
            SignUserInfoHclcHis signUserInfoHclcHis = new SignUserInfoHclcHis();
            signUserInfoHclcHis.setOpenId(openId);
            signUserInfoHclcHis.setAuthFlag("Y");
            userInfoHclcHisList = signUserInfoHclcHisMapper.select(signUserInfoHclcHis);
            if (userInfoHclcHisList.size() > 0) {
                signInfoHclc = new SignUserInfoHclc();
                //取历史注册信息中最后的一期
                Optional<SignUserInfoHclcHis> maxResult = userInfoHclcHisList.stream().max(Comparator.comparing(SignUserInfoHclcHis::getHisId));
                if (maxResult.isPresent()) {
                    signUserInfoHclcHis = maxResult.get();
                    BeanUtils.copyProperties(signUserInfoHclcHis, signInfoHclc);
                    signInfoHclc.setHistoryFlag("Y");
                }
            }

        }

        if (signInfoHclc != null) {
            signInfoHclcs.add(signInfoHclc);
        }
        return new ResponseData(signInfoHclcs);
    }

    /**
     * 创建个人用户
     *
     * @param request
     * @param dto     创建个人用户
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/accounts/outerAccounts/create")
    public Map<String, Object> addPersonAccount(HttpServletRequest request,
                                                @RequestBody SignUserInfoHclc dto) {
        Map<String, Object> map = new HashMap<>();
        IRequest iRequest = createRequestContext(request);
        map = signHclcService.addPersonAccount(dto);
        if ("0".equalsIgnoreCase(map.get("code").toString())) {
            dto = signHclcService.selectByPrimaryKey(iRequest, dto);
            dto.setAccountId(map.get("accountId").toString());
            signHclcService.updateByPrimaryKey(createRequestContext(request), dto);
        }
        return map;

    }

    /**
     * 注销个人用户
     *
     * @param request
     * @param dto     注销个人用户
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/accounts/outerAccounts/delete")
    public Map<String, Object> deletePersonAccount(HttpServletRequest request,
                                                   @RequestBody SignUserInfoHclc dto) {
        IRequest iRequest = createRequestContext(request);
        Map<String, Object> map = new HashMap<>();
        if (Objects.isNull(dto.getOpenId())) {
            map.put("code", "000005");
            map.put("message", "关键参数openId不存在，调用失败!");
            return map;
        }
        map = signHclcService.deletePersonAccount(iRequest, dto);
        if ("0".equalsIgnoreCase(map.get("code").toString()) || "40051667".equalsIgnoreCase(map.get("code").toString()) || "000003".equalsIgnoreCase(map.get("code").toString())) {
            dto = signHclcService.selectByPrimaryKey(iRequest, dto);
            SignUserInfoHclcHis signUserInfoHclcHis = new SignUserInfoHclcHis();
            BeanUtils.copyProperties(dto, signUserInfoHclcHis);
            signUserInfoHclcHisService.insert(iRequest, signUserInfoHclcHis);
            signHclcService.deleteByPrimaryKey(dto);
        }
        return map;

    }

    /**
     * 创建机构用户
     *
     * @param request
     * @param dto     创建机构用户
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/organizations/outerOrgans/create")
    public Map<String, Object> addOrgansAccount(HttpServletRequest request,
                                                @RequestBody SignUserInfoHclc dto) {

        Map<String, Object> map = new HashMap<>();
        IRequest iRequest = createRequestContext(request);
        map = organSignHclcService.addOrgansAccount(dto);
        if ("0".equalsIgnoreCase(map.get("code").toString())) {
            dto = signHclcService.selectByPrimaryKey(iRequest, dto);
            dto.setAccountId(map.get("organizeId").toString());
            signHclcService.updateByPrimaryKey(createRequestContext(request), dto);
        }
        return map;

    }

    /**
     * 注销机构用户
     *
     * @param request
     * @param dto     注销机构用户
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/organizations/outerOrgans/delete")
    public Map<String, Object> deleteOrgansAccount(HttpServletRequest request,
                                                   @RequestBody SignUserInfoHclc dto) {
        Map<String, Object> map = new HashMap<>();
        IRequest iRequest = createRequestContext(request);

        if (Objects.isNull(dto.getOpenId())) {
            map.put("code", "000005");
            map.put("message", "关键参数openId不存在，调用失败!");
        }

        //注销机构账户
        map = organSignHclcService.deleteOrgansAccount(iRequest, dto);
        if ("0".equalsIgnoreCase(map.get("code").toString()) || "40051667".equalsIgnoreCase(map.get("code").toString()) || "000003".equalsIgnoreCase(map.get("code").toString())) {
            dto = signHclcService.selectByPrimaryKey(iRequest, dto);
            //复制用户信息到历史表
            SignUserInfoHclcHis signUserInfoHclcHis = new SignUserInfoHclcHis();
            BeanUtils.copyProperties(dto, signUserInfoHclcHis);
            signUserInfoHclcHisService.insert(iRequest, signUserInfoHclcHis);

            //重置结构用户信息为空
            dto.setAccountId("");
            dto.setAuthAccountId("");
            dto.setOrgAuthId(null);
            dto.setAuthFlag("N");
            dto.setCreateCode("");
            dto.setCreateMessage("");
            dto.setManagerAuthFlag("N");

            //注销经办人用户
            SignUserInfoHclc agentSignInfo = new SignUserInfoHclc();
            agentSignInfo.setOpenId(dto.getOpenId());
            map = signHclcService.deletePersonAccount(iRequest, agentSignInfo);
            if ("0".equalsIgnoreCase(map.get("code").toString()) || "40051667".equalsIgnoreCase(map.get("code").toString()) || "000003".equalsIgnoreCase(map.get("code").toString())) {
//                if ("N".equalsIgnoreCase(dto.getIsManagerFlag())) {
//                    map = organSignHclcService.unBindOrgansAgent(dto);
//                }
                signHclcService.deleteByPrimaryKey(dto);

                //复制用户信息到历史表
                //初始化经办人人脸识别信息
                SignUserInfoHclc agentSignInfo2 = new SignUserInfoHclc();
                agentSignInfo2.setOpenId(dto.getOpenId() + "personHclc");
                agentSignInfo2 = signHclcService.selectByPrimaryKey(iRequest, agentSignInfo2);

                SignUserInfoHclcHis agentUserInfoHclcHis = new SignUserInfoHclcHis();
                BeanUtils.copyProperties(agentSignInfo2, agentUserInfoHclcHis);
                signUserInfoHclcHisService.insert(iRequest, agentUserInfoHclcHis);
                signHclcService.deleteByPrimaryKey(agentSignInfo2);

                map.put("code", "0");
            } else {
                signHclcService.updateByPrimaryKey(iRequest, dto);
            }

            //机构已注销，accountaId为空的情况
        } else if ("000012".equalsIgnoreCase(map.get("code").toString())) {
            //注销经办人用户
            map = signHclcService.deletePersonAccount(iRequest, dto);
            if ("0".equalsIgnoreCase(map.get("code").toString()) || "40051667".equalsIgnoreCase(map.get("code").toString()) || "000003".equalsIgnoreCase(map.get("code").toString())) {
                signHclcService.deleteByPrimaryKey(dto);

                //复制用户信息到历史表
                //初始化经办人人脸识别信息
                SignUserInfoHclc agentSignInfo = new SignUserInfoHclc();
                agentSignInfo.setOpenId(dto.getOpenId() + "personHclc");
                agentSignInfo = signHclcService.selectByPrimaryKey(iRequest, agentSignInfo);

                SignUserInfoHclcHis agentUserInfoHclcHis = new SignUserInfoHclcHis();
                BeanUtils.copyProperties(agentSignInfo, agentUserInfoHclcHis);
                signUserInfoHclcHisService.insert(iRequest, agentUserInfoHclcHis);
                signHclcService.deleteByPrimaryKey(agentSignInfo);
                map.put("code", "0");
            }
        }

        return map;

    }

    /**
     * 获取人身核验地址
     *
     * @param request
     * @param dto     获取人身核验地址
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/auth/api/individual/face")
    public Map<String, Object> getIndividualFaceUrl(HttpServletRequest request,
                                                    @RequestBody SignUserInfoHclc dto) {
        return signHclcService.getIndividualFaceUrl(createRequestContext(request), dto);

    }

    /**
     * 获取机构核验地址
     *
     * @param request
     * @param dto     获取机构核验地址
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/auth/api/individual/face/Organ")
    public Map<String, Object> getOrganIndividualFaceUrl(HttpServletRequest request,
                                                         @RequestBody SignUserInfoHclc dto) {
        return organSignHclcService.getOrganIndividualFaceUrl(createRequestContext(request), dto);

    }

    /**
     * 获取人身核验地址
     *
     * @param request
     * @param dto     获取人身核验地址
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/auth/api/license/ocr")
    public JSONObject getOcrLicense(HttpServletRequest request,
                                             @RequestBody SignUserInfoHclc dto) {

        String img = "";
        String realPath = "d:\\1610543886923.jpg";
        File file = new File(realPath);
        FileInputStream inputFile;
        byte[] buffer = null;
        try {
            inputFile = new FileInputStream(file);
            buffer = new byte[(int) file.length()];
            inputFile.read(buffer);
            inputFile.close();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        img= Base64.encodeBase64String(buffer);

        return signHclcService.ocrLicense(createRequestContext(request), img);

    }

    /**
     * 经办人授权/取消授权
     *
     * @param request
     * @param lists<SignUserInfoHclc> 经办人授权/取消授权
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/auth/api/individual/authorize")
    public Map<String, Object> setOrganIndividualAuthorize(HttpServletRequest request,
                                                           @RequestBody List<SignUserInfoHclc> lists) {
        Map<String, Object> map = new HashMap<>();
        IRequest iRequest = createRequestContext(request);

        for (SignUserInfoHclc dto : lists) {
            if (Objects.isNull(dto.getOpenId()) || Objects.isNull(dto.getManagerAuthFlag())) {
                map.put("code", "000001");
                map.put("message", "关键参数openId、managerAuthFlag不存在，调用失败!");
                return map;
            } else {
                try {
                    SignUserInfoHclc signUserInfoHclc = new SignUserInfoHclc();
                    signUserInfoHclc.setOpenId(dto.getOpenId());
                    signUserInfoHclc = signHclcService.selectByPrimaryKey(iRequest, signUserInfoHclc);
                    if (Objects.nonNull(signUserInfoHclc) && Objects.nonNull(signUserInfoHclc.getOpenId())) {
                        if ("Y".equalsIgnoreCase(dto.getManagerAuthFlag())) {
                            map = organSignHclcService.bindOrgansAgent(signUserInfoHclc);
                        } else if ("N".equalsIgnoreCase(dto.getManagerAuthFlag())) {
                            map = organSignHclcService.unBindOrgansAgent(signUserInfoHclc);
                        } else {
                            map.put("code", "000003");
                            map.put("message", "managerAuthFlag参数有误，请检查！");
                            continue;
                        }
                        if ("0".equalsIgnoreCase(map.get("code").toString())) {
                            signHclcService.updateByPrimaryKeySelective(iRequest, dto);
                            map.put("code", "000000");
                            map.put("message", "操作成功！");
                        } else {
                            map.put("code", "000004");
                        }
                    }
                } catch (Exception e) {
                    map.put("code", "000002");
                    map.put("message", "操作失败，请检查！");
                    return map;
                }
            }
        }

        //map.put("code", "000000");
        //map.put("message", "操作成功！");
        return map;

    }

    /**
     * 经办人信息查询
     *
     * @param request
     * @param dto     经办人信息查询
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/auth/api/individual/info/query")
    public ResponseData getOrganIndividualInfoQuery(HttpServletRequest request,
                                                    @RequestBody SignUserInfoHclc dto) {
        IRequest requestContext = createRequestContext(request);
        List<SignUserInfoHclc> signInfoHclcs = new ArrayList<>();
        SignUserInfoHclc signInfoHclc = new SignUserInfoHclc();
        signInfoHclc.setIdNo(dto.getIdNo());
        signInfoHclc.setIsManagerFlag("N");
        signInfoHclc.setManagerAuthFlag(dto.getManagerAuthFlag());

        signInfoHclcs = organSignHclcService.getOrganIndividualInfoQuery(requestContext, signInfoHclc);
        return new ResponseData(signInfoHclcs);
    }

    /**
     * 管理权限转让
     *
     * @param request
     * @param dto     管理权限转让
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/auth/api/individual/assignment")
    public Map<String, Object> setOrganIndividualAssignment(HttpServletRequest request,
                                                            @RequestBody SignUserInfoHclc dto) {
        Map<String, Object> map = new HashMap<>();
        IRequest iRequest = createRequestContext(request);

        if (Objects.isNull(dto.getOpenId())) {
            map.put("code", "000001");
            map.put("message", "关键参数openId，调用失败!");
            return map;
        } else {
            try {
                //新管理员角色
                SignUserInfoHclc infoHclc = new SignUserInfoHclc();
                infoHclc.setOpenId(dto.getOpenId());
                infoHclc = signHclcService.selectByPrimaryKey(iRequest, infoHclc);

                if (Objects.isNull(infoHclc.getName()) || Objects.isNull(infoHclc.getAgentIdNo())) {
                    map.put("code", "000004");
                    map.put("message", "被转移用户信息异常，org_name:" + infoHclc.getName() + "agentIdNo:" + infoHclc.getAgentIdNo() + "请先联系代理店处理！");
                    return map;
                }

                JSONObject param = new JSONObject();
                param.put("org_name", infoHclc.getName());
                param.put("agentIdNo", infoHclc.getAgentIdNo());

                String isManager = organSignHclcService.getManagerStatus(param);
                if (infoHclc.getAgentType().compareTo(1L) != 0 && "N".equalsIgnoreCase(isManager)) {
                    map.put("code", "000003");
                    map.put("message", "被转移用户未在代理店登记管理信息，请先联系代理店处理！");
                    return map;
                }


                if (Objects.nonNull(infoHclc) && !"Y".equalsIgnoreCase(infoHclc.getAuthFlag())) {
                    map.put("code", "000002");
                    map.put("message", "用户未完成认证，无法授权授权，请先认证！");
                    return map;
                }
                infoHclc.setIsManagerFlag("Y");
                organSignHclcService.setOrganIndividualAssignment(iRequest, infoHclc);
                organSignHclcService.bindOrgansAgent(infoHclc);

                //原管理员角色
                SignUserInfoHclc signUserInfoHclc = new SignUserInfoHclc();
                signUserInfoHclc.setOpenId(dto.getOldOpenId());
                signUserInfoHclc.setIsManagerFlag("N");
                signHclcService.updateByPrimaryKeySelective(iRequest, signUserInfoHclc);
            } catch (Exception e) {
                map.put("code", "000003");
                map.put("message", "操作失败，请检查！");
                return map;
            }
        }

        map.put("code", "000000");
        map.put("message", "操作成功！");
        return map;
    }

    /**
     * 外部机构绑定经办人
     *
     * @param request
     * @param dto     外部机构绑定经办人
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/auth/api/bind/organs/agent")
    public Map<String, Object> bindOrgansAgent(HttpServletRequest request,
                                               @RequestBody SignUserInfoHclc dto) {
        Map<String, Object> map = new HashMap<>();
        IRequest iRequest = createRequestContext(request);

        if (Objects.isNull(dto.getOpenId())) {
            map.put("code", "000001");
            map.put("message", "关键参数openId，调用失败!");
            return map;
        } else {
            try {
                dto = signInfoHclcMapper.selectByPrimaryKey(dto);
                map = organSignHclcService.bindOrgansAgent(dto);
            } catch (Exception e) {
                map.put("code", "000003");
                e.printStackTrace();
                map.put("message", "操作失败" + e.getMessage() + "，请检查！");
                return map;
            }
        }

        map.put("code", "000000");
        map.put("message", "操作成功！");
        return map;
    }

    /**
     * 下载微信图片资源上传业务系统
     *
     * @param request
     * @param dto     下载微信图片资源上传业务系统
     */
    @RequestMapping(value = "/auth/upload/image/hls/from/wx", method = RequestMethod.POST)
    @ResponseBody
    public JSONObject uploadHlsFromWx(HttpServletRequest request, @RequestBody AttachmentInfo dto) {
        return signHclcService.uploadHlsFromWx(createRequestContext(request), dto);
    }

    /**
     * 文件直传
     *
     * @param request
     * @param dto     文件直传
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/sign/files/upload")
    public Map<String, Object> signFileUpload(HttpServletRequest request,
                                              @RequestBody AttachmentInfo dto) {
        return signHclcService.signFileUpload(createRequestContext(request), dto);

    }

    /**
     * 文件直传
     *
     * @param request
     * @param dto     文件直传
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/sign/files/download")
    public Map<String, Object> signFileDownload(HttpServletRequest request,
                                                @RequestBody AttachmentInfo dto) {
        return signHclcService.signFileDownload(createRequestContext(request), dto);

    }

    /**
     * 创建签署流程
     *
     * @param request
     * @param params  创建签署流程
     * @return Map
     */
    @ResponseBody
    @RequestMapping(value = "/sign/flows/create", method = RequestMethod.POST)
    public JSONObject createSignFlows(HttpServletRequest request,
                                      @RequestBody(required = true) JSONObject params) {
        return signHclcService.createSignFlows(createRequestContext(request), params);
    }


    /**
     * 创建印章
     *
     * @param request
     * @param dto     创建签署流程
     * @return Map
     */
    @ResponseBody
    @RequestMapping(value = "/sign/seal/create", method = RequestMethod.POST)
    public JSONObject createPersonSeal(HttpServletRequest request,
                                       @RequestBody SignUserInfoHclc dto) {
        JSONObject json = new JSONObject();
        String sealId = signHclcService.createTemplateSeals(dto.getAccountId(), dto.getOpenId());
        json.put("sealId", sealId);
        return json;
    }

    /**
     * 签署流程作废
     *
     * @param request
     * @param params     签署流程作废
     * @return Map
     */
    @ResponseBody
    @RequestMapping(value = "/sign/flows/cancel", method = RequestMethod.POST)
    public JSONObject cancelSignFlows(HttpServletRequest request,
                                      @RequestBody(required = true) JSONObject params) {
        return signHclcService.cancelSignFlows(createRequestContext(request), params);
    }

//    /**
//     * 创建签署流程
//     *
//     * @param request
//     * @param params  创建签署流程
//     * @return Map
//     */
//    @ResponseBody
//    @RequestMapping(value = "/sign/flows/cancel", method = RequestMethod.POST)
//    public JSONObject cancelSignFlows(HttpServletRequest request,
//                                      @RequestBody(required = true) JSONObject params) {
//        return signHclcService.cancelSignFlows(createRequestContext(request), params);
//    }


    /**
     * 电子合同消息发送
     */
    @RequestMapping(value = "/send/wx/message", method = RequestMethod.POST)
    @ResponseBody
    public JSONObject sendWxTemplateMsg(HttpServletRequest request, @RequestBody(required = true) JSONObject params) {
        JSONObject json = new JSONObject();
        try {
            //根据客户名称，证件号码获取对应的openId信息
//            String idNo = params.getString("idNo");
//            String name = params.getString("name");
//            String openId = null;
//            SignUserInfoHclc signInfoHclc = new SignUserInfoHclc();
//            List<SignUserInfoHclc> infoHclcs = new ArrayList<>();
//            signInfoHclc.setName(name);
//            signInfoHclc.setIdNo(idNo);
//            infoHclcs = signInfoHclcMapper.select(signInfoHclc);
//            if (infoHclcs.size() > 0) {
//                openId = infoHclcs.get(0).getOpenId();
//            } else {
//                //查询历史注册信息
//                SignUserInfoHclcHis signUserInfoHclcHis = new SignUserInfoHclcHis();
//                List<SignUserInfoHclcHis> userInfoHclcHisList = new ArrayList<>();
//                signUserInfoHclcHis.setName(name);
//                signUserInfoHclcHis.setIdNo(idNo);
//                userInfoHclcHisList = signUserInfoHclcHisMapper.select(signUserInfoHclcHis);
//                if (userInfoHclcHisList.size() > 0) {
//                    openId = userInfoHclcHisList.get(0).getOpenId();
//                }
//            }
//
//            if (openId != null) {
//                params.put("openId", openId);
//            }
            String id = params.getString("openId");
            if (id.contains("personHclc")) {
                id = id.replace("personHclc", "");
            }
            params.put("openId", id);
            params.put("templateId", "lyMDp1r6Jp5r7eSiho0otSby4tY0pXjZg1gbcA1poNI");
            params.put("first", "您好，您申请的融资租赁合同已经通过审核，可以进行签约流程！");
            params.put("keyword1", "承租人：测试");
            params.put("keyword2", "合同号：测试a");
            params.put("keyword3", "机号：测试123456");
            params.put("keyword4", "签约时间：20200827");
            params.put("remark", "请点击互动中心-融资租赁进行签约。谢谢！");
            params.put("url", "");

            json = signHclcService.sendWxTemplateMsg(params);
        } catch (Exception e) {
            json.put("code", "000002");
            json.put("message", "微信消息发送失败");
            e.printStackTrace();
        }
        return json;
    }

}
