package com.hand.app.cmb.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.chinapay.comm.Constants;
import com.chinapay.dto.HlsEbankCcbTransaction;
import com.chinapay.mapper.HlsEbankCcbTransactionMapper;
import com.chinapay.secss.LogUtil;
import com.chinapay.service.IHlsEbankCcbTransactionService;
import com.chinapay.util.StringUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.hand.app.cmb.dto.Ld037;
import com.hand.app.cmb.mapper.Ld037Mapper;
import com.hand.app.cmb.service.HclcCmbPolyService;
import com.hand.app.cmb.util.MD5Utils;
import com.hand.app.cmb.util.SM2Util;
import com.hand.app.cmb.util.SignatureUtil;
import com.hand.app.cmb.util.Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.app.zhongDengWang.dto.HlsWsRequests;
import com.hand.app.zhongDengWang.mapper.HlsWsRequestsMapper;
import com.hand.hap.core.IRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class HclcCmbPolyServiceImpl implements HclcCmbPolyService {
    private static final String url = "https://api.cmburl.cn:8065/polypay/v1.0/mchorders/qrcodeapply";  //UAT

    private static final String closeUrl = "https://api.cmburl.cn:8065/polypay/v1.0/mchorders/qrcodeapply";  //UAT

    //uat环境商户国密私钥
    public static final String privateKey = "D5F2AFA24E6BA9071B54A8C9AD735F9A1DE9C4657FA386C09B592694BC118B38";
    //uat环境招行国密公钥
    public static final String publicKey = "MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAE6Q+fktsnY9OFP+LpSR5Udbxf5zHCFO0PmOKlFNTxDIGl8jsPbbB/9ET23NV+acSz4FEkzD74sW2iiNVHRLiKHg==";

    public static final String appId = "8ab74856-8772-45c9-96db-54cb30ab9f74";
    public static final String appSecret = "5b96f20a-011f-4254-8be8-9a5ceb2f317f";

    /*接口区分*/
    public static final String getQrCode = "GET_QR_CODE";

    /*代扣交易状态*/
    public static final String transNew = "NEW";
    public static final String transDeal = "DEAL";
    public static final String transFail = "FAIL";
    public static final String transClose = "CLOSED";

    /*交易结果状态*/
    public static final String cmbSuccess = "SUCCESS";
    public static final String cmbFail = "FAIL";

    @Value("${cmb.version}")
    private String version;
    @Value("${cmb.encoding}")
    private String encoding;
    @Value("${cmb.signMethod}")
    private String signMethod;

    /*币种，非必传，默认156人民币*/
    @Value("${cmb.currencyCode}")
    private String currencyCode;

    @Value("${cmb.user.id}")
    private String cmbUserId;
    @Value("${cmb.mer.id}")
    private String cmbMerId;

    @Autowired
    private HlsEbankCcbTransactionMapper hlsEbankCcbTransactionMapper;
    @Autowired
    private IHlsEbankCcbTransactionService hlsEbankCcbTransactionService;
    @Autowired
    private HlsWsRequestsMapper hlsWsRequestsMapper;
    @Autowired
    private Ld037Mapper ld037Mapper;

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public JSONObject getQrcode(IRequest iRequest, JSONObject params) {
        JSONObject result = new JSONObject();
        String resultType = "-1";
        String errorCd = null;

        if (Objects.isNull(params.get("recamt_id"))) {
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "请求必须参数recamt_id缺失，请检查！");
            return result;
        }

        //根据recamt_id查询ld037数据生成hls_ebank_ccb_transaction批次记录
        Long recamtId = params.getLong("recamt_id");
        Ld037 ld037 = new Ld037();
        ld037.setId(recamtId);
        ld037 = ld037Mapper.selectByPrimaryKey(ld037);

        if (Objects.nonNull(ld037.getReceiptstatus())) {
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "支付订单状态异常，请检查！");
            return result;
        }

        HlsEbankCcbTransaction hlsEbankCcbTransaction = createTransaction(iRequest, ld037);
        ld037.setTransactionId(hlsEbankCcbTransaction.getTransactionId());

        //生成单据编号 日期+id
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        String dateString = formatter.format(new Date());
        hlsEbankCcbTransaction.setTransactionNumber(dateString + String.format("%08d", hlsEbankCcbTransaction.getTransactionId()));

//        Map<String, String> requestPublicParams = JSONObject.parseObject(params.toJSONString(), Map.class);
        // 组装requestBody并加签
        String signResult = getQrRequestParams(hlsEbankCcbTransaction, ld037);
        if (Objects.isNull(signResult)) {
            result.put(Constants.RESP_CODE, "E");
            result.put(Constants.RESP_MSG, "收款码申请加签发生异常，请检查！");
            return result;
        }

        Map<String, String> response = null;

        try {
            ObjectMapper mapper = new ObjectMapper();
            Map<String, String> signResultMap = mapper.readValue(signResult, Map.class);
            long currentTimeMills = System.currentTimeMillis() / 1000;

            // 组apiSign加密Map
            Map<String, String> apiSign = new TreeMap<>();
            apiSign.put("appid", appId);
            apiSign.put("secret", appSecret);
            apiSign.put("sign", signResultMap.get("sign"));
            apiSign.put("timestamp", "" + currentTimeMills);

            // MD5加密
            String MD5Content = SignatureUtil.getSignContent(apiSign);
            String apiSignString = MD5Utils.getMD5Content(MD5Content).toLowerCase();

            // 组request头部Map
            Map<String, String> apiHeader = new HashMap<>();
            apiHeader.put("appid", appId);
            apiHeader.put("timestamp", "" + currentTimeMills);
            apiHeader.put("apisign", apiSignString);

            //初始化日志
            HlsWsRequests hlsWsRequests = logInterfaceRequest(getQrCode, url, mapper.writeValueAsString(apiHeader), hlsEbankCcbTransaction.getTransactionId());
            logger.info("发送收款码申请请求,请求参数: {}", mapper.writeValueAsString(apiHeader));
            try {
                // 发送HTTP post请求
                response = Utils.postForEntity(url, signResult, apiHeader);

                //处理接口日志
                logger.info("收款码申请返回结果：" + mapper.writeValueAsString(response));
                hlsWsRequests.setResponseClob(mapper.writeValueAsString(response));
                hlsWsRequests.setReturnStatus("S");
                hlsWsRequests.setResponsedDate(new Date());

                // 返回结果验签,验证数据的正确性（安全性）
                Boolean checkResult1 = checkSign(mapper.writeValueAsString(response));

                //数据验签成功
                if (checkResult1) {
                    //获取返回码,返回码不为SUCCESS表示报文内的字段不符合规范
                    String returnCode = response.get("returnCode");
                    if ("SUCCESS".equalsIgnoreCase(returnCode)) {
                        //响应码
                        String respCode = response.get("respCode");
                        if ("SUCCESS".equalsIgnoreCase(respCode)) {
                            resultType = "1";
                        } else {
                            resultType = "2";
                        }
                    } else {
                        resultType = "3";
                    }

                    if (!"1".equalsIgnoreCase(resultType)) {
                        //更新现金事务表ld037失败处理
                        errorCd = response.get("errCode");
                    }
                }
                //数据验签失败
                else {
                    //更新现金事务表ld037失败处理
                    errorCd = "SIGN_ERROR";

                    //直接返回前端验签失败信息，重发或者直接告诉前端发送失败
                    resultType = "4";
                }
            } catch (Exception e) {
                e.printStackTrace();
                logger.info("发送请求异常: {} ", e.getMessage());

                //更新现金事务表ld037失败处理
                errorCd = "SEND_ERROR";

                //处理接口日志
                hlsWsRequests.setReturnStatus("E");
                hlsWsRequests.setResponsedDate(new Date());

                //请求批次事务表状态更新失败处理
                hlsEbankCcbTransaction.setReturnMsg(e.getMessage());
                result.put(Constants.RESP_MSG, "发送请求异常:" + e.getMessage());
                resultType = "5";
            }

            hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);

        } catch (Exception e) {
            e.printStackTrace();
            logger.info("组装请求报文信息失败: {} ", e.getMessage());

            //请求批次事务表状态更新失败处理
            hlsEbankCcbTransaction.setReturnMsg("组装请求报文信息失败:" + e.getMessage());
            result.put(Constants.RESP_MSG, "组装请求报文信息失败:" + e.getMessage());

            errorCd = "MESSAGE_ERROR";
            resultType = "5";
        }

        hlsEbankCcbTransaction = setEbankTransaction(hlsEbankCcbTransaction, response, resultType);
        hlsEbankCcbTransactionMapper.updateByPrimaryKey(hlsEbankCcbTransaction);

        //更新现金事务表ld037失败处理
        if (Objects.nonNull(errorCd)) {
            updateLd037Fail(ld037, errorCd);
        } else {
            ld037Mapper.updateByPrimaryKeySelective(ld037);
        }

        result = putResult(result, response, resultType);
        return result;
    }

    private JSONObject putResult(JSONObject result, Map<String, String> response, String type) {
        //接口请求成功
        if ("1".equalsIgnoreCase(type)) {
            JSONObject bizContent = new JSONObject();
            bizContent = JSONObject.parseObject(response.get("biz_content").toString());
            result.put(Constants.RESP_CODE, response.get("returnCode"));
            result.put(Constants.RESP_MSG, "请求成功");
            //测试环境处理，生产需要还原
            result.put("qrcode", bizContent.getString("qrCode").replace("https://qr.95516.com/", "http://payment-uat.cs.cmburl.cn/"));
            result.put("cmborderid", bizContent.getString("cmbOrderId"));
            result.put("txnTime", bizContent.getString("txnTime"));
        }
        //接口返回成功，响应失败
        else if ("2".equalsIgnoreCase(type) || "3".equalsIgnoreCase(type)) {
            result.put(Constants.RESP_CODE, response.get("errCode"));
            result.put(Constants.RESP_MSG, response.get("respMsg"));
        }
        //验签失败
        else if ("4".equalsIgnoreCase(type)) {
            result.put(Constants.RESP_CODE, cmbFail);
            result.put(Constants.RESP_MSG, "验签失败，请检查！");
        }
        //组装请求报文信息失败
        else if ("5".equalsIgnoreCase(type)) {
            result.put(Constants.RESP_CODE, cmbFail);
        }
        return result;
    }

    private HlsEbankCcbTransaction setEbankTransaction(HlsEbankCcbTransaction hlsEbankCcbTransaction, Map<String, String> response, String type) {
        //接口请求成功
        if ("1".equalsIgnoreCase(type)) {
            JSONObject bizContent = new JSONObject();
            bizContent = JSONObject.parseObject(response.get("biz_content").toString());
            hlsEbankCcbTransaction.setStatus(transDeal);
            hlsEbankCcbTransaction.setReturnCode(response.get("returnCode"));
            hlsEbankCcbTransaction.setReturnMsg("获取二维码成功");
            hlsEbankCcbTransaction.setQrCode(bizContent.getString("qrCode"));
            hlsEbankCcbTransaction.setCmbOrderId(bizContent.getString("cmbOrderId"));
            hlsEbankCcbTransaction.setTxnTime(bizContent.getString("txnTime"));
            hlsEbankCcbTransaction.setOrderStatus("0000");
        }
        //接口返回成功，响应失败
        else if ("2".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setStatus(transFail);
            hlsEbankCcbTransaction.setReturnCode(response.get("errCode"));
            hlsEbankCcbTransaction.setReturnMsg(response.get("respMsg"));
            hlsEbankCcbTransaction.setOrderStatus("0000");
        }
        //接口返回失败
        else if ("3".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setStatus(transFail);
            hlsEbankCcbTransaction.setReturnCode(response.get("errCode"));
            hlsEbankCcbTransaction.setReturnMsg(response.get("respMsg"));
            hlsEbankCcbTransaction.setOrderStatus("0003");
        }
        //验签失败
        else if ("4".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setStatus(transFail);
            hlsEbankCcbTransaction.setReturnCode("SIGN_ERROR");
            hlsEbankCcbTransaction.setReturnMsg("接口请求验签失败");
            hlsEbankCcbTransaction.setOrderStatus("0003");
        }
        //组装请求报文信息失败
        else if ("5".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setStatus(transFail);
            hlsEbankCcbTransaction.setReturnCode("SEND_ERROR");
            hlsEbankCcbTransaction.setOrderStatus("0003");
        }
        return hlsEbankCcbTransaction;
    }

    private void updateLd037Fail(Ld037 ld037, String errorCd) {
        ld037.setErrorcd(errorCd);
        ld037Mapper.updateLd037Fail(ld037);
    }

    //生成招行扫码交易业务批次数据
    private HlsEbankCcbTransaction createTransaction(IRequest iRequest, Ld037 ld037) {
        HlsEbankCcbTransaction ccbTransaction = new HlsEbankCcbTransaction();
        ccbTransaction.setMerId(cmbMerId);
        ccbTransaction.setVersion(version);
        ccbTransaction.setUserId(cmbUserId);
        ccbTransaction.setStatus(transNew);
        ccbTransaction.setBankType("CMB");
        ccbTransaction.setCount(1L);
        ccbTransaction.setAmount(ld037.getAmount());
        ccbTransaction.setNewDate(new Date());
        ccbTransaction.setCreatedBy(1L);
        ccbTransaction.setCreationDate(new Date());
        ccbTransaction.setLastUpdatedBy(1L);
        ccbTransaction.setTranDate(StringUtil.getRelevantDate(new Date()));
        ccbTransaction.setTranTime(StringUtil.getRelevantTime(new Date()));
        ccbTransaction.setTranType("APPLY");

        hlsEbankCcbTransactionMapper.insert(ccbTransaction);

//        //生成单据编号 日期+id
//        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
//        String dateString = formatter.format(new Date());
//        ccbTransaction.setTransactionNumber(dateString + String.format("%08d", ccbTransaction.getTransactionId()));
//        ccbTransaction = hlsEbankCcbTransactionService.updateByPrimaryKeySelective(iRequest, ccbTransaction);

        return hlsEbankCcbTransactionMapper.selectByPrimaryKey(ccbTransaction);
    }

    private String getQrRequestParams(HlsEbankCcbTransaction hlsEbankCcbTransaction, Ld037 ld037) {
        Map<String, String> requestPublicParams = new TreeMap<>();
        String requestStr = null;
        try {
            //公共请求参数
            requestPublicParams.put("version", version);    //版本号，固定为0.0.1(必传字段)
            requestPublicParams.put("encoding", encoding);   //编码方式，固定为UTF-8(必传)
            requestPublicParams.put("signMethod", signMethod);    //签名方法，固定为02，表示签名方式为国密(必传)

            //业务要素
            Map<String, String> requestTransactionParams = new HashMap<>();
            requestTransactionParams.put("merId", hlsEbankCcbTransaction.getMerId());   //商户号(必传)
            requestTransactionParams.put("orderId", hlsEbankCcbTransaction.getTransactionNumber()); //商户订单号(必传)
            requestTransactionParams.put("userId", hlsEbankCcbTransaction.getUserId());   //收银员
            //            requestTransactionParams.put("termId", "00774411");  //终端号
            requestTransactionParams.put("payValidTime", "900"); //支付有效时间,默认15分钟
            requestTransactionParams.put("notifyUrl", "http://sign.hitachics.com/core/api/public/cmb/get/qr/code/listen");  //交易通知地址(必传)
            requestTransactionParams.put("mchReserved", ld037.getId().toString());  //交易通知地址(必传)

            BigDecimal a1 = new BigDecimal(Double.toString(hlsEbankCcbTransaction.getAmount()));
            BigDecimal b1 = new BigDecimal(Double.toString(100));
            requestTransactionParams.put("txnAmt", a1.multiply(b1).stripTrailingZeros().toPlainString());  //交易金额,单位为分(必传)
            requestTransactionParams.put("currencyCode", currencyCode);    //交易币种，默认156，目前只支持人民币（156）
//            requestTransactionParams.put("body", "聚合支付测试");   //商户号(必传)
            requestTransactionParams.put("body", "聚合支付测试");

            //商户保留域
            JSONObject mchReserved = new JSONObject();
            mchReserved.put("transactionId", hlsEbankCcbTransaction.getTransactionId());
            requestTransactionParams.put("tradeScene", "OFFLINE");   //交易场景

            ObjectMapper mapper = new ObjectMapper();
            requestPublicParams.put("biz_content", mapper.writeValueAsString(requestTransactionParams));

            logger.info("收款码申请加签前的报文内容:" + mapper.writeValueAsString(requestPublicParams));

            //对待加签内容进行排序拼接
            String signContent = SignatureUtil.getSignContent(requestPublicParams);
            //加签
            requestPublicParams.put("sign", SM2Util.sm2Sign(signContent, privateKey));

            requestStr = mapper.writeValueAsString(requestPublicParams);
            logger.info("收款码申请加签后的报文内容：" + requestStr);
            return requestStr;

        } catch (Exception e) {
            logger.info("收款码申请加签发生异常：" + e.getMessage());
            e.printStackTrace();
            return requestStr;
        }
    }

    private Boolean checkSign(String string) {
        System.out.println("要验签的报文内容：" + string);
        try {
            //验签
            ObjectMapper objectMapper = new ObjectMapper();
            Map<String, String> responseBodyMap = objectMapper.readValue(string, Map.class);
            String sign = responseBodyMap.remove("sign");
            String contentStr = SignatureUtil.getSignContent(responseBodyMap);
            boolean result = SM2Util.sm2Check(contentStr, sign, publicKey);

            if (result) {
                System.out.println("报文验签成功!");
            } else {
                System.out.println("报文验签失败!");
            }
            return result;
        } catch (Exception e) {
            System.out.println("验签发生异常！");
            e.printStackTrace();
            return false;
        }
    }

    private Properties loadProp(String propPath) {
        Properties props = new Properties();
        FileInputStream is = null;

        try {
            is = new FileInputStream(propPath);
            props.load(is);
            return props;
        } catch (Exception var13) {
            LogUtil.writeErrorLog("加载配置文件失败", var13);
        } finally {
            if (is != null) {
                try {
                    is.close();
                } catch (IOException var12) {
                    ;
                }
            }

        }
        return null;
    }

    public HlsWsRequests logInterfaceRequest(String functionName, String url, String request, Long pkValue) {

        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests.setRequestDate(new Date());
        hlsWsRequests.setRequestWsdlUrl(url);
        hlsWsRequests.setFunctionName(functionName);

        String tableName = getTableName(functionName);
        hlsWsRequests.setTableName(tableName);
        hlsWsRequests.setStatusCode("1");
        hlsWsRequests.setStatusDate(new Date());
        hlsWsRequests.setPkValue(pkValue);
        hlsWsRequests.setRequestClob(request);
        hlsWsRequestsMapper.insertSelective(hlsWsRequests);

        return hlsWsRequests;
    }

    private String getTableName(String functionName) {
        String tableName = "";
        if ("GET_QR_CODE".equalsIgnoreCase(functionName)) {
            tableName = "HLS_EBANK_CCB_TRANSACTION";
        } else if ("QUERY_PAY_RESULT".equalsIgnoreCase(functionName)) {
            tableName = "HLS_EBANK_CMB_QUERY";
        }

        return tableName;

    }

    @Override
    public JSONObject queryOrderStatus(IRequest iRequest, JSONObject params) {
        //返回结果标志
        String resultType = null;
        JSONObject result = new JSONObject();
        final String url = "https://api.cmburl.cn:8065/polypay/v1.0/mchorders/orderquery";

        //去ld037中查找对应的记录的receiptcfmstatus，
        if (Objects.isNull(params.get("recamt_id"))) {
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "请求必须参数recamt_id缺失，请检查！");
            return result;
        }

        //根据recamt_id查询ld037数据生成hls_ebank_ccb_transaction批次记录
        Long recamtId = params.getLong("recamt_id");
        Ld037 ld037 = new Ld037();
        ld037.setId(recamtId);
        ld037 = ld037Mapper.selectByPrimaryKey(ld037);

        //与查询二维码有区别，查询二维码时订单并未创建，但查询订单状态时，订单记录已经在数据库中有记录，
        // 所以只需要通过recamt_id在ld037表中查到对应的订单记录，
        // 然后通过ld037表中的transaction_id找到对应的hlsEbankCcbTransaction对象
        HlsEbankCcbTransaction hlsEbankCcbTransaction = hlsEbankCcbTransactionMapper.selectByPrimaryKey(ld037.getTransactionId());
        // HlsEbankCcbTransaction hlsEbankCcbTransaction = createTransaction(ld037)
        String signResult = getOrderQueryParameter(hlsEbankCcbTransaction);
        if (hlsEbankCcbTransaction.getOrderStatus().equals(cmbSuccess)) {
            result.put(Constants.RESP_CODE, hlsEbankCcbTransaction.getReturnCode());
            result.put(Constants.RESP_MSG, hlsEbankCcbTransaction.getReturnMsg());
            //给到前端订单的状态
            result.put("tradeState", hlsEbankCcbTransaction.getOrderStatus());
            return result;
        }
        ObjectMapper mapper = new ObjectMapper();
        Map<String, String> signResultMap = null;
        try {
            signResultMap = mapper.readValue(signResult, Map.class);
        } catch (IOException e) {
            resultType = "5";
            e.printStackTrace();
        }
        long currentTimeMills = System.currentTimeMillis() / 1000;


        // 组apiSign加密Map
        Map<String, String> apiSign = new TreeMap<>();
        apiSign.put("appid", appId);
        apiSign.put("secret", appSecret);
        apiSign.put("sign", signResultMap.get("sign"));
        apiSign.put("timestamp", "" + currentTimeMills);

        // MD5加密
        String MD5Content = "";
        try {
            MD5Content = SignatureUtil.getSignContent(apiSign);
        } catch (Exception e) {
            e.printStackTrace();
        }
        String apiSignString = MD5Utils.getMD5Content(MD5Content).toLowerCase();

        // 组request头部Map
        Map<String, String> apiHeader = new HashMap<>();
        apiHeader.put("appid", appId);
        apiHeader.put("timestamp", "" + currentTimeMills);
        apiHeader.put("apisign", apiSignString);
        //发送http请求
        Map<String, String> responseMap = Utils.postForEntity(url, signResult, apiHeader);
        if (null == responseMap) {
            resultType = "3";
            logger.info("响应的内容为空");
            return result;
        }
        //处理响应报文
        Boolean checkResponse = null;
        try {
            checkResponse = checkSign(mapper.writeValueAsString(responseMap));
        } catch (JsonProcessingException e) {
            resultType = "4";
            e.printStackTrace();
        }
        //数据验签成功        if (checkResponse) {
        //获取返回码,返回码不为SUCCESS表示报文内的字段不符合规范
        String returnCode = responseMap.get("returnCode");
        if ("SUCCESS".equalsIgnoreCase(returnCode)) {
            //响应码
            String respCode = responseMap.get("returnCode");
            if ("SUCCESS".equalsIgnoreCase(respCode)) {
                //成功拿到订单状态请求的响应
                resultType = "1";
            } else {
                //请求成功，但是响应结果为失败，传给前端失败原因就行
                resultType = "2";
            }
        } else {
            //返回码都失败
            resultType = "3";
        }

        if (!"1".equalsIgnoreCase(resultType)) {
            //更新现金事务表ld037失败处理
            updateLd037Fail(ld037, responseMap.get("errCode"));
        }
        //数据验签失败
        else {
            //更新现金事务表ld037失败处理
            updateLd037Fail(ld037, "SIGN_ERROR");
            //直接返回前端验签失败信息，重发或者直接告诉前端发送失败
            resultType = "4";
        }
        hlsEbankCcbTransaction = setEbankTransactionQR(hlsEbankCcbTransaction, responseMap, resultType);
        hlsEbankCcbTransactionMapper.updateByPrimaryKeySelective(hlsEbankCcbTransaction);

        result = putResult(result, responseMap, resultType);
        return result;
    }

    /**
     * 封装请求参数，其中包含商户订单号，作为招行收到请求定位到对应订单的条件
     *
     * @param hlsEbankCcbTransaction
     * @return
     */
    private static String getOrderQueryParameter(HlsEbankCcbTransaction hlsEbankCcbTransaction) {
        Map<String, String> requestPublicParams = new TreeMap<>();
        String requestStr = null;
        try {
            //公共请求参数
            requestPublicParams.put("version", "0.0.1");    //版本号，固定为0.0.1(必传字段)
            requestPublicParams.put("encoding", "UTF-8");   //编码方式，固定为UTF-8(必传)
            requestPublicParams.put("signMethod", "02");    //签名方法，固定为02，表示签名方式为国密(必传)
            //业务要素
            Map<String, String> requestTransactionParams = new HashMap<>();
            requestTransactionParams.put("merId", hlsEbankCcbTransaction.getMerId());   //商户号(必传)
            requestTransactionParams.put("orderId", hlsEbankCcbTransaction.getTransactionNumber()); //商户订单号(必传)
            requestTransactionParams.put("userId", hlsEbankCcbTransaction.getUserId());   //收银员
            ObjectMapper mapper = new ObjectMapper();
            requestPublicParams.put("biz_content", mapper.writeValueAsString(requestTransactionParams));
            /*冗余列，因为关闭订单中的请求参数名称与其余请求的参数名称不同*/
            requestTransactionParams.put("origOrderId", hlsEbankCcbTransaction.getTransactionNumber()); //商户订单号(必传)

            System.out.println("加签前的报文内容：" + mapper.writeValueAsString(requestPublicParams));

            //对待加签内容进行排序拼接
            String signContent = SignatureUtil.getSignContent(requestPublicParams);
            //加签
            requestPublicParams.put("sign", SM2Util.sm2Sign(signContent, privateKey));

            requestStr = mapper.writeValueAsString(requestPublicParams);

            System.out.println("加签后的报文内容：" + requestStr);
            return requestStr;

        } catch (Exception e) {
            System.out.println("加签发生异常！");
            e.printStackTrace();
            return requestStr;
        }
    }


    /**
     * 封装交易表批次信息表
     *
     * @param hlsEbankCcbTransaction
     * @param response
     * @param type
     * @return
     */
    private HlsEbankCcbTransaction setEbankTransactionQR(HlsEbankCcbTransaction hlsEbankCcbTransaction, Map<String, String> response, String type) {
//        C - 订单已关闭
//        D - 交易已撤销
//        P - 交易在进行
//        F - 交易失败
//        S - 交易成功
//        R - 转入退款

        //接口请求成功
        if ("1".equalsIgnoreCase(type)) {
            if (response.get("tradeState").equalsIgnoreCase("P")) {
                hlsEbankCcbTransaction.setStatus(transDeal);
                hlsEbankCcbTransaction.setOrderStatus("P");
            } else if (response.get("tradeState").equalsIgnoreCase("S")) {
                hlsEbankCcbTransaction.setStatus(cmbSuccess);
                hlsEbankCcbTransaction.setOrderStatus("S");
            } else if (response.get("tradeState").equalsIgnoreCase("C")) {
                hlsEbankCcbTransaction.setStatus(transClose);
                hlsEbankCcbTransaction.setOrderStatus("C");
            } else if (response.get("tradeState").equalsIgnoreCase("F")) {
                hlsEbankCcbTransaction.setStatus(transFail);
                hlsEbankCcbTransaction.setOrderStatus("F");
            }
        }
        //接口返回成功，响应失败
        else if ("2".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setReturnCode(response.get("errCode"));
            hlsEbankCcbTransaction.setReturnMsg(response.get("respMsg"));
            hlsEbankCcbTransaction.setOrderStatus("0000");
        }
        //接口返回失败
        else if ("3".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setReturnCode(response.get("errCode"));
            hlsEbankCcbTransaction.setReturnMsg(response.get("respMsg"));
            hlsEbankCcbTransaction.setOrderStatus("0003");
        }
        //验签失败
        else if ("4".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setReturnCode("SIGN_ERROR");
            hlsEbankCcbTransaction.setReturnMsg("接口请求验签失败");
            hlsEbankCcbTransaction.setOrderStatus("0003");
        }
        //组装请求报文信息失败
        else if ("5".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setReturnCode("SEND_ERROR");
            hlsEbankCcbTransaction.setOrderStatus("0003");
        }

        return hlsEbankCcbTransaction;
    }

    /**
     * 封装给前端的返回结果
     *
     * @param result
     * @param response
     * @param type
     * @return
     */
    private JSONObject putResultQR(JSONObject result, Map<String, String> response, String type) {
        //接口请求成功
        if ("1".equalsIgnoreCase(type)) {

            result.put(Constants.RESP_CODE, response.get("returnCode"));
            result.put(Constants.RESP_MSG, "请求成功");
            result.put("orderId", response.get("orderId"));
            result.put("cmbOrderId", response.get("cmbOrderId"));
            result.put("tradeState", response.get("tradeState"));
            result.put("txnTime", response.get("txnTime"));
        }
        //接口返回成功，响应失败
        else if ("2".equalsIgnoreCase(type)) {
            result.put(Constants.RESP_CODE, response.get("errCode"));
            result.put(Constants.RESP_MSG, response.get("respMsg"));
        }
        //接口返回失败
        else if ("3".equalsIgnoreCase(type)) {
            result.put(Constants.RESP_CODE, response.get("errCode"));
            result.put(Constants.RESP_MSG, response.get("respMsg"));
        }
        //验签失败
        else if ("4".equalsIgnoreCase(type)) {
            result.put(Constants.RESP_CODE, cmbFail);
            result.put(Constants.RESP_MSG, "验签失败，请检查！");
        }
        //组装请求报文信息失败
        else if ("5".equalsIgnoreCase(type)) {
            result.put(Constants.RESP_CODE, cmbFail);
        }
        return result;
    }

    @Override
    public Map<String, String> orderNotify(IRequest iRequest, JSONObject params) {
        JSONObject result = new JSONObject();
        System.out.println(params);
        String requestBodyString = params.toJSONString();
        Map<String, String> respData = new HashMap<>();
        //设置响应数据
        respData.put("version", "0.0.1");//版本号，固定为0.0.1(必传)
        respData.put("encoding", "UTF-8");//编码方式，固定为UTF-8(必传)
        respData.put("signMethod", "02");//签名方法，固定为02，国密
        try {
            respData.put("returnCode", "SUCCESS"); //SUCCESS表示商户接收通知成功并校验成功
            //非空校验
            if (requestBodyString == null || "".equals(requestBodyString.trim())) {
                respData.put("returnCode", "FAIL");
                return respData;
            }
            Map<String, String> requestBodyMap = str2Map(requestBodyString);
            Map<String, String> resultMap = requestBodyMap.entrySet().stream().collect(Collectors.toMap(e -> SignatureUtil.decode(e.getKey()), e -> SignatureUtil.decode(e.getValue())));
            if (resultMap == null) {
                respData.put("returnCode", "FAIL");
                return respData;
            }
            String sign = resultMap.remove("sign");
            //对待加签内容进行排序拼接
            String contentStr = SignatureUtil.getSignContent(resultMap);
            //验证签名-使用招行公钥进行验签
            boolean flag = SM2Util.sm2Check(contentStr, sign, publicKey);
            if (!flag) {
                //验签失败
                System.out.println("验签失败");
                respData.put("returnCode", "FAIL");
                return respData;
            }
            System.out.println("验签成功");

            Long recamtId = params.getLong("mchReserved");
            Ld037 ld037 = new Ld037();
            ld037.setId(recamtId);
            ld037 = ld037Mapper.selectByPrimaryKey(ld037);

            /*对请求结果进行保存*/
            HlsEbankCcbTransaction hlsEbankCcbTransaction = hlsEbankCcbTransactionMapper.selectByPrimaryKey(ld037.getTransactionId());
            hlsEbankCcbTransaction.setStatus(cmbSuccess);
            hlsEbankCcbTransaction.setOrderStatus("S");
            hlsEbankCcbTransactionMapper.updateByPrimaryKeySelective(hlsEbankCcbTransaction);

            respData.put("respCode", "SUCCESS");//业务错误码，成功为SUCCESS，失败为FAIL
            /*如果处理自身业务逻辑发生错误，返回
            respData.put("respCode","FAIL");
            respData.put("respMsg","error_msg");
             */
            //对待加签内容进行排序拼接
            String signContent = SignatureUtil.getSignContent(respData);
            //加签-使用商户私钥加签
            respData.put("sign", SM2Util.sm2Sign(signContent, privateKey));
            System.out.println("加签成功");
            return respData;
        } catch (Exception e) {
            e.printStackTrace();
            respData.put("returnCode", "FAIL");
            return respData;
        }
    }

    @Override
    public JSONObject closeOrder(IRequest iRequest, JSONObject params) {
        JSONObject result = new JSONObject();

        if (Objects.isNull(params.get("recamt_id"))) {
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "请求必须参数recamt_id缺失，请检查！");
            return result;
        }

        //根据recamt_id查询ld037数据生成hls_ebank_ccb_transaction批次记录
        Long recamtId = params.getLong("recamt_id");
        Ld037 ld037 = new Ld037();
        ld037.setId(recamtId);
        ld037 = ld037Mapper.selectByPrimaryKey(ld037);
        HlsEbankCcbTransaction hlsEbankCcbTransaction = hlsEbankCcbTransactionMapper.selectByPrimaryKey(ld037.getTransactionId());
        /**
         * 支付成功的订单不允许关单，需要修改返回代码
         */
        if ("SUCCESS".equalsIgnoreCase(hlsEbankCcbTransaction.getStatus())) {
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "订单已经支付成功！");
            return result;
        }

        //开始封装请求部分
        String signResult = getOrderQueryParameter(hlsEbankCcbTransaction);
        ObjectMapper mapper = new ObjectMapper();
        Map<String, String> signResultMap = null;
        try {
            signResultMap = mapper.readValue(signResult, Map.class);
        } catch (IOException e) {
            /// resultType = "5";
            e.printStackTrace();
        }
        long currentTimeMills = System.currentTimeMillis() / 1000;

        // 组apiSign加密Map
        Map<String, String> apiSign = new TreeMap<>();
        apiSign.put("appid", appId);
        apiSign.put("secret", appSecret);
        apiSign.put("sign", signResultMap.get("sign"));
        apiSign.put("timestamp", "" + currentTimeMills);

        // MD5加密
        String MD5Content = "";
        try {
            MD5Content = SignatureUtil.getSignContent(apiSign);
        } catch (Exception e) {
            e.printStackTrace();
        }
        String apiSignString = MD5Utils.getMD5Content(MD5Content).toLowerCase();

        // 组request头部Map
        Map<String, String> apiHeader = new HashMap<>();
        apiHeader.put("appid", appId);
        apiHeader.put("timestamp", "" + currentTimeMills);
        apiHeader.put("apisign", apiSignString);

        Map<String, String> responseMap = Utils.postForEntity(closeUrl, signResult, apiHeader);
        //处理响应报文
        Boolean checkResponse = null;
        try {
            checkResponse = checkSign(mapper.writeValueAsString(responseMap));
        } catch (JsonProcessingException e) {
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "数据验签失败");
            e.printStackTrace();
        }
        //数据验签成功        if (checkResponse) {
        //获取返回码,返回码不为SUCCESS表示报文内的字段不符合规范
        String returnCode = responseMap.get("returnCode");
        if ("SUCCESS".equalsIgnoreCase(returnCode)) {
            //响应码
            String respCode = responseMap.get("returnCode");
            if ("ORDER_PAID".equalsIgnoreCase(respCode)) {
                //需要调用退款接口
                result.put(Constants.RESP_CODE, "E");
                result.put("respMsg", "需要调用退款接口！");
                return result;
            } else if ("SUCCESS".equalsIgnoreCase(respCode)) {
                //订单关闭成功
                if ("C".equalsIgnoreCase(responseMap.get("closeState"))) {
                    hlsEbankCcbTransaction.setStatus(transClose);
                    hlsEbankCcbTransaction.setOrderStatus("C");
                    result.put(Constants.RESP_CODE, responseMap.get("respCode"));
                    result.put(Constants.RESP_MSG, "请求成功");
                    result.put("cmborderid", responseMap.get("origOrderId"));
                    result.put("closeState", responseMap.get("closeState"));
                    result.put("txnTime", responseMap.get("txnTime"));
                }
                //关单失败处理
                else {
                    hlsEbankCcbTransaction.setOrderStatus("F");
                    result.put(Constants.RESP_CODE, responseMap.get("respCode"));
                    result.put(Constants.RESP_MSG, "请求成功");
                    result.put("cmborderid", responseMap.get("origOrderId"));
                    result.put("closeState", responseMap.get("closeState"));
                    result.put("txnTime", responseMap.get("txnTime"));
                }
            } else if ("SYSTERM_ERROR".equalsIgnoreCase(respCode)) {
                //请求成功，但是响应结果为失败，传给前端失败原因就行
                result.put(Constants.RESP_CODE, "E");
                result.put("respMsg", "需要重新调用查询接口！");
            } else if ("FAIL".equalsIgnoreCase(respCode)) {
                result.put("errCode", responseMap.get("errCode"));
                result.put("respMsg", responseMap.get("respMsg"));
            }
        } else {
            //返回码都失败
            result.put("errCode", responseMap.get("errCode"));
            result.put("respMsg", responseMap.get("respMsg"));
        }
        hlsEbankCcbTransactionMapper.updateByPrimaryKey(hlsEbankCcbTransaction);
        return result;
    }


    private Map<String, String> str2Map(String str) {
        Map<String, String> result = new HashMap<>();
        String[] results = str.split("&");
        if (results != null && results.length > 0) {
            for (int var = 0; var < results.length; ++var) {
                String pair = results[var];
                String[] kv = pair.split("=", 2);
                if (kv != null && kv.length == 2) {
                    result.put(kv[0], kv[1]);
                }
            }
        }
        return result;
    }

}
