package com.hand.app.appManger.controllers;

import com.codahale.metrics.annotation.Timed;
import com.hand.app.appManger.dto.AppModule;
import com.hand.app.appManger.dto.AppRole;
import com.hand.app.appManger.service.IAppRoleService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;

import com.hand.hap.system.dto.ResponseData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created by Think-PC on 2018/3/14.
 */
@Controller
@RequestMapping(value = {"/r/api","/"})
public class AppRoleController extends BaseController {
    @Autowired
    private IAppRoleService appRoleService;

    @RequestMapping(value = "/app/queryRole")
    @ResponseBody
    public ResponseData query(AppRole dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(appRoleService.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value = "/app/addRole", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public ResponseData addRole(HttpServletRequest request, @RequestBody List<AppRole> dto, BindingResult result) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return  new ResponseData(appRoleService.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value = "/app/deleteRole", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public int deleteRole(HttpServletRequest request,@RequestBody List<AppRole> approle){
        return appRoleService.batchDelete(approle);
    }

}
