package com.hand.app.appManger.controllers;

import com.hand.app.appManger.dto.AppModule;
import com.hand.app.appManger.service.IAppModuleService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;

import com.hand.hap.system.dto.ResponseData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created by Think-PC on 2018/3/14.
 */
@Controller
@RequestMapping("/app/module")
public class AppModuleController extends BaseController {
    @Autowired
    private IAppModuleService appModuleService;

    @RequestMapping(value = "/query")
    @ResponseBody
    public ResponseData query(AppModule dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(appModuleService.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value = "/submit")
    @ResponseBody
    public ResponseData addModule(HttpServletRequest request, @RequestBody List<AppModule> dto, BindingResult result) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return  new ResponseData(appModuleService.batchUpdate(requestCtx, dto));
    }
    @RequestMapping(value = "/remove")
    @ResponseBody
    public int deleteAppModule(HttpServletRequest request,@RequestBody List<AppModule> appModule){
        return appModuleService.batchDelete(appModule);
    }
}
