package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.ReferenceType;
import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;

/**
 * Created by lrd on 2017/7/19.
 */
@UITag
public class HlsDataSource extends Component implements HlsComponent {
    private static final String PROPERTITY_SUCCESS_END = "successEnd";
    private static final String PROPERTITY_AUTO_QUERY = "autoQuery";
    private static final String PROPERTITY_AUTO_FETCH = "autoFetch";
    private static final String PROPERTITY_HLSTRANSPORT = "transport";
    private static final String PROPERTITY_PARAMETER_MAP = "parameterMap";
    public static final String PROPERTITY_READ = "read";
    private static final String PROPERTITY_URL = "URL";
    private static final String PROPERTITY_TYPE = "type";
    private static final String PROPERTITY_DATA_TYPE = "dataType";
    private static final String PROPERTITY_ASYNC = "async";
    private static final String PROPERTITY_PAGE = "page";
    private static final String PROPERTITY_PAGE_SIZE = "pageSize";


    public HlsDataSource() {
    }
    @Override
    public void hlsSetPropertity(Object key, Object value) {
        // TODO Auto-generated method stub
        super.setPropertity(key, value);
    }

    public static HlsDataSource createInstance() {
        XMap view = new XMap("h", "http://www.hand-china.com/hap", "hlsDataSource");
        HlsDataSource hlsDataSource = new HlsDataSource();
        hlsDataSource.initPrototype(view);
        return hlsDataSource;
    }
    public String getPageSize() {
        return this.getPrototype().getString(PROPERTITY_PAGE_SIZE);
    }
    public String getPage() {
        return this.getPrototype().getString(PROPERTITY_PAGE);
    }
    public String getAutoFetch() {
        return this.getPrototype().getString(PROPERTITY_AUTO_FETCH);
    }
    public String getSuccessEnd() {
        return this.getPrototype().getString(PROPERTITY_SUCCESS_END);
    }
    public String getAutoQuery() {
        return this.getPrototype().getString(PROPERTITY_AUTO_QUERY);
    }
    public String getAsync() {
        return this.getPrototype().getString(PROPERTITY_ASYNC);
    }
    public Object getTransport() {
        Transport transport = new Transport();
        XMap map = this.getPrototype().getChild("transport");
        if(map != null) {
            transport.setRead(TransportMethod.parse(map.getChild("read")));
            if(map.getString("parameterMap") != null) {
                transport.setParameterMap(new ReferenceType(map.getString("parameterMap")));
            }
            return transport;
        } else {
            return null;
        }
    }

    public void setTransport(Transport transport) {
        XMap map = this.getPrototype().getChild("transport");
        if(map == null) {
            map = this.getPrototype().createChild("h", "http://www.hand-china.com/hap", "transport");
        }

        map.addChild(transport.toXMap());
    }

    protected void initPrototype(XMap view) {
        super.initPrototype(view);
    }

    public void init(XMap view, ViewContext context) throws Exception {
        super.init(view, context);
        context.put(PROPERTITY_SUCCESS_END, getSuccessEnd());
        context.put(PROPERTITY_AUTO_QUERY, getAutoQuery());
        context.put(PROPERTITY_ASYNC, getAsync());
        context.put(PROPERTITY_AUTO_FETCH,getAutoFetch());
        context.addJsonConfig(PROPERTITY_HLSTRANSPORT, this.getTransport());
        context.addJsonConfig(PROPERTITY_ASYNC,getAsync());
        context.addJsonConfig(PROPERTITY_AUTO_FETCH, getAutoFetch());
        context.addJsonConfig(PROPERTITY_PAGE, getPage());
        context.addJsonConfig(PROPERTITY_PAGE_SIZE, getPageSize());
    }
}
