package com.hand.app.ocr.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.SignatureException;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;

public class HttpClientPost {

    public static JSONObject post(String post_url,MultipartEntity entity){
        JSONObject json = null;
        HttpClient httpclient = new DefaultHttpClient();
        HttpPost post = new HttpPost(post_url);
        String Authorization = "";
        try{
            Authorization = GenerateString.genHeaderParam();
        } catch (SignatureException e) {
            json = new JSONObject();
            json.put("Code","E");
            json.put("Message",e.toString());
        }
//        post.addHeader("Content-type", "application/json; charset=utf-8");
//        post.setHeader("Accept", "application/json");
        post.setEntity(entity);
        post.setHeader("Authorization", Authorization);//签名认证
        try{
             HttpResponse response = httpclient.execute(post);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entitys = response.getEntity();
                BufferedReader reader = new BufferedReader(
                        new InputStreamReader(entitys.getContent(),"utf-8"));
                String line = reader.readLine();
                json = JSONObject.parseObject(line);
                System.out.println(line);
            }else{
                HttpEntity r_entity = response.getEntity();
                String responseString = EntityUtils.toString(r_entity);
                json = new JSONObject();
                json.put("Code",response.getStatusLine().getStatusCode() + response.getStatusLine().getReasonPhrase());
                json.put("Message",responseString);
            }
            httpclient.getConnectionManager().shutdown();

        } catch (Exception e) {
            json = new JSONObject();
            json.put("Code","E");
            json.put("Message",e.toString());
        }
        return  json;
    }
}
