package com.hand.app.esignHclc.controllers;

import com.hand.app.esignHclc.service.ISignInfoHclcFaceService;
import com.hand.app.esignHclc.service.ISignInfoHclcService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * Created with IntelliJ IDEA.
 * User: lsy
 * Date: 2020/2/25
 * Time: 21:32
 */
@Controller
public class SignHclcListenController extends BaseController {

    @Autowired
    private ISignInfoHclcFaceService iSignInfoHclcFaceService;
    @Autowired
    private ISignInfoHclcService iSignInfoHclcService;

    @ResponseBody
    @RequestMapping(value = "/api/public/listen/auth/result", method = RequestMethod.POST)
    public ResponseData postAuthResult(HttpServletRequest request,
                                       @RequestBody(required = false) JSONObject params) {
        ResponseData responseData = new ResponseData(false);
        iSignInfoHclcFaceService.postAuthResult(createRequestContext(request), params);
        responseData.setCode("200");
        responseData.setSuccess(true);
        responseData.setMessage("接收成功！");
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value = "/api/public/listen/sign/flow", method = RequestMethod.POST)
    public ResponseData postSignFlowsResult(HttpServletRequest request,
                                       @RequestBody(required = false) JSONObject params) {
        ResponseData responseData = new ResponseData(false);
        iSignInfoHclcService.postSignFlowsResult(createRequestContext(request), params);
        responseData.setCode("200");
        responseData.setSuccess(true);
        responseData.setMessage("接收成功！");
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value = "/api/public/user", method = RequestMethod.POST)
    public JSONObject posttest(HttpServletRequest request,
                                            @RequestBody(required = false) JSONObject params) {
        JSONObject responseData = new JSONObject();
        responseData.put("objectVersionNumber",1);
        responseData.put("_token","eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9/eyJhdWQiOlsiYXBpLXJlc291cmNlIl0sInVzZXJfbmFt==");
        responseData.put("id",1);
        responseData.put("code","lishuangyi");
        responseData.put("name","黎双意");
        return responseData;
    }
}
