package com.hand.app.esign.dto;

import com.hand.hap.mybatis.annotation.ExtensionAttribute;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.app.esign.bean.AttachmentInfo;
import com.hand.app.esign.bean.SignPage;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: yang
 * Date: 2018/1/19
 * Time: 16:08
 */
@Table(name = "ORGANIZE_SIGN_INFO")
@ExtensionAttribute(disable = true)
public class OrganSignInfo extends BaseDTO {

    @Id
    private String organCode;
    private String name;
    private Integer organType;
    private String regType;
    private Integer userType;
    private String agentName;
    private String agentIdNo;
    private String legalName;
    private Integer legalArea;
    private String legalIdNo;
    private String scope;
    private String mobile;
    private String email;
    private String address;


    private String sealData; // e签宝 签章内容
    private String accountId; // e签宝账户id

    @Transient
    private String hText; //横向文字
    @Transient
    private  String qText; //下弦文字

    @Transient
    private List<SignPage> userPages; // 用户签名信息

    @Transient
    private List<String> userKeys;

    @Transient
    private List<String> selfKeys;

    @Transient
    private List<SignPage> selfPages; // 平台签名信息@Transient
    @Transient
    private AttachmentInfo attachmentInfo; // 附件信息

    public List<String> getUserKeys() {
        return userKeys;
    }

    public void setUserKeys(List<String> userKeys) {
        this.userKeys = userKeys;
    }

    public List<String> getSelfKeys() {
        return selfKeys;
    }

    public void setSelfKeys(List<String> selfKeys) {
        this.selfKeys = selfKeys;
    }

    public AttachmentInfo getAttachmentInfo() {
        return attachmentInfo;
    }

    public void setAttachmentInfo(AttachmentInfo attachmentInfo) {
        this.attachmentInfo = attachmentInfo;
    }

    public List<SignPage> getUserPages() {
        return userPages;
    }

    public void setUserPages(List<SignPage> userPages) {
        this.userPages = userPages;
    }

    public List<SignPage> getSelfPages() {
        return selfPages;
    }

    public void setSelfPages(List<SignPage> selfPages) {
        this.selfPages = selfPages;
    }

    public String getOrganCode() {
        return organCode;
    }

    public void setOrganCode(String organCode) {
        this.organCode = organCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getOrganType() {
        return organType;
    }

    public void setOrganType(Integer organType) {
        this.organType = organType;
    }

    public String getRegType() {
        return regType;
    }

    public void setRegType(String regType) {
        this.regType = regType;
    }

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getAgentIdNo() {
        return agentIdNo;
    }

    public void setAgentIdNo(String agentIdNo) {
        this.agentIdNo = agentIdNo;
    }

    public String getLegalName() {
        return legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public Integer getLegalArea() {
        return legalArea;
    }

    public void setLegalArea(Integer legalArea) {
        this.legalArea = legalArea;
    }

    public String getLegalIdNo() {
        return legalIdNo;
    }

    public void setLegalIdNo(String legalIdNo) {
        this.legalIdNo = legalIdNo;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getSealData() {
        return sealData;
    }

    public void setSealData(String sealData) {
        this.sealData = sealData;
    }

    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String gethText() {
        return hText;
    }

    public void sethText(String hText) {
        this.hText = hText;
    }

    public String getqText() {
        return qText;
    }

    public void setqText(String qText) {
        this.qText = qText;
    }
}
