package com.hand.app.electronicSignature.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.hand.app.electronicSignature.dto.EleSignConData;
import com.hand.app.electronicSignature.dto.EleSignContract;
import com.hand.app.electronicSignature.dto.EleSignSeal;
import com.hand.app.electronicSignature.mapper.EleSignConDataMapper;
import com.hand.app.electronicSignature.mapper.EleSignContractMapper;
import com.hand.app.electronicSignature.mapper.EleSignSealMapper;
import com.hand.app.electronicSignature.service.IElectronicSignatureContract;
import com.hand.app.hms.mapper.HmsThirdpartyAppMapper;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import constant.APIToolKitException;
import constant.ProtocolConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import request.*;
import request.bean.ContractDataItem;
import request.bean.KeyWordInfo;
import request.bean.SignInfo;
import request.bean.Signatory;
import service.SignAPI;
import util.Base64;
import util.StringUtil;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.List;


@Service
public class ElectronicSignatureContractImpl extends BaseServiceImpl<EleSignContract> implements IElectronicSignatureContract {

    @Autowired
    private EleSignContractMapper eleSignContractMapper;
    @Autowired
    private EleSignConDataMapper eleSignConDataMapper;
    @Autowired
    private EleSignSealMapper eleSignSealMapper;

    @Autowired
    HmsThirdpartyAppMapper thirdpartyAppMapper;

    private static String SIGN_PDF_PATH;


    //1010创建合同(模板方式)
    public JSONObject createContractTemplate(EleSignContract param) throws  Exception{
        JSONObject returnJson = new JSONObject();
        try {
            Tx1010Request tx1010Request = new Tx1010Request();
            tx1010Request.setTemplateId(param.getTemplateId());
            tx1010Request.setSerialNumber(param.getSerialNumber());
            tx1010Request.setContractName(param.getContractName());
            List<EleSignConData> conDataList =  param.getConDataList();
            tx1010Request.setContractData(getContractDataItems(conDataList));
            tx1010Request.setAttachmentName(param.getAttachmentName());
            tx1010Request.setAttachmentContentHash(param.getAttachmentContentHash());
            tx1010Request.setContractName(param.getContractName());
            List<EleSignSeal> eleSignSealList = param.getSealList();
            tx1010Request.setSignatories(getSignature(eleSignSealList));
            String response = SignAPI.sendMessageAndGetResult(tx1010Request);
            returnJson.put("ResponseCode",StringUtil.getNodeText(response,"ResponseCode"));
            returnJson.put("ResponseDesc",StringUtil.getNodeText(response,"ResponseDesc"));
            returnJson.put("txId", StringUtil.getNodeText(response, "TxID"));
            param.setResponseCode(returnJson.getString("ResponseCode"));
            param.setResponseDesc(returnJson.getString("ResponseDesc"));
            param.setTxId(returnJson.getString("txId"));
        } catch (APIToolKitException e) {
            e.printStackTrace();
        }
        eleSignContractMapper.insertSelective(param);
        return returnJson;
    }
    public  LinkedList<ContractDataItem> getContractDataItems(List<EleSignConData> conDataList){
        LinkedList<ContractDataItem> contractDataItems = new LinkedList<ContractDataItem>();
        for(int i = 0;i<conDataList.toArray().length;i++){
            ContractDataItem contractDataItem = new ContractDataItem();
            contractDataItem.setContractDataKey(conDataList.get(i).getContractDataKey());
            contractDataItem.setContractDataValue(conDataList.get(i).getContractDataValue());
            contractDataItem.setContractDataKey(conDataList.get(i).getContractDataKey());
            contractDataItems.add(contractDataItem);
            eleSignConDataMapper.insertSelective(conDataList.get(i));
        }
        return  contractDataItems;
    }

    public  LinkedList<Signatory> getSignature( List<EleSignSeal> eleSignSealList){
        LinkedList<Signatory> signatories = new LinkedList<Signatory>();
        if(eleSignSealList!=null) {
            for (int i = 0; i < eleSignSealList.toArray().length; i++) {
                Signatory signatory = new Signatory();
                signatory.setUserId(eleSignSealList.get(i).getUserId());
                signatory.setLocation(eleSignSealList.get(i).getLocation());
                signatory.setSignLocation(eleSignSealList.get(i).getSignLocation());
                signatory.setAuthorizationTime(eleSignSealList.get(i).getAuthorizationTime());
                signatories.add(signatory);
                eleSignSealMapper.insertSelective(eleSignSealList.get(i));
            }
        }
        return signatories;

    }

    //1011创建合同(上传合同文件方式)
    public  JSONObject createContractFile(EleSignContract param) throws IOException {
        JSONObject returnJson = new JSONObject();
        try{
            Tx1011Request tx1011Request = new Tx1011Request();
            tx1011Request.setContractType(param.getContractType());
            tx1011Request.setPlatformSignatory(param.getPlatformIsSignatory());
            tx1011Request.setSerialNumber(param.getSerialNumber());
            tx1011Request.setContractName(param.getContractName());
            tx1011Request.setContractFile(param.getContractFile());
            tx1011Request.setPlatformSignInfo(getSignInfoKeyWord(param));
            List<EleSignSeal> eleSignSealList = param.getSealList();
            tx1011Request.setSignatories(getSignature(eleSignSealList));
            tx1011Request.setSealId(param.getSealId());
            String response = SignAPI.sendMessageAndGetResult(tx1011Request);
            returnJson.put("ResponseCode",StringUtil.getNodeText(response,"ResponseCode"));
            returnJson.put("ResponseDesc",StringUtil.getNodeText(response,"ResponseDesc"));
            returnJson.put("txId", StringUtil.getNodeText(response, "TxID"));
            returnJson.put("contractId", StringUtil.getNodeText(response, "contractId"));
        }catch(APIToolKitException e){
            e.printStackTrace();
        }
        return returnJson;
    }

    public static SignInfo getSignInfoKeyWord(EleSignContract param){
        SignInfo signInfo = new SignInfo();
        KeyWordInfo keyWordInfo =new KeyWordInfo();
        keyWordInfo.setKeyWord(param.getKeyWord());
        keyWordInfo.setOffsetX(param.getOffsetX());
        keyWordInfo.setOffsetY(param.getOffsetY());
        keyWordInfo.setSealHeight(param.getSealHeight());
        keyWordInfo.setSealWith(param.getSealWith());
        signInfo.setKeyWordInfo(keyWordInfo);
        return signInfo;
    }

    //1019下载合同
    public  JSONObject downloadContract(EleSignContract param) throws  Exception{
        JSONObject returnJson = new JSONObject();
        try{
            SIGN_PDF_PATH = thirdpartyAppMapper.selectByCode("sign.attachment.download").getAppKey();
            Tx1019Request tx1019Request = new Tx1019Request();
            tx1019Request.setContractId(param.getContractId());
            String response = SignAPI.sendMessageAndGetResult(tx1019Request);
            String contractFile = StringUtil.getNodeText(response, ProtocolConstant.CONTRACT_FILE);
            byte[] fileBytes  = Base64.base64ToByteArray(contractFile);
            try {
                String filePath = SIGN_PDF_PATH + "pdf";
               // String filePath = "./file";
                File dir = new File(filePath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File file = new File(filePath + File.separator + param.getContractId() + ".pdf");
                try{
                    FileOutputStream fos = new FileOutputStream(file);
                    fos.write(fileBytes);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            returnJson.put("ResponseCode",StringUtil.getNodeText(response,"ResponseCode"));
            returnJson.put("ResponseDesc",StringUtil.getNodeText(response,"ResponseDesc"));
            returnJson.put("txId", StringUtil.getNodeText(response, "TxID"));
            returnJson.put("contractFile", StringUtil.getNodeText(response, "contractFile"));
        }
        catch(APIToolKitException e){
            e.printStackTrace();
        }
        return returnJson;
    }

}
