package com.hand.app.electronicSignature.demo;

import constant.APIToolKitException;
import request.Tx1010Request;
import request.bean.ContractDataItem;
import request.bean.Signatory;
import service.SignAPI;
import java.util.LinkedList;

public class Test1010 {
    public static void main(String[] args)  {
        try {
            SignAPI.initAPI("./APIConfig");
            Tx1010Request tx1010Request = new Tx1010Request();
            tx1010Request.setTemplateId("ZL_502");
            tx1010Request.setSerialNumber("7ADBDD5ED80D743FE050007F010009B5");
            tx1010Request.setContractName("123");

            tx1010Request.setContractData(getContractDataItems());
            tx1010Request.setAttachmentName("abc.txt");
            tx1010Request.setAttachmentContentHash("123");
            tx1010Request.setSignatories(getSignatores());
            String response = SignAPI.sendMessageAndGetResult(tx1010Request);
            System.out.println(response);
        } catch (APIToolKitException e) {
            e.printStackTrace();
        }
    }
    public static LinkedList<Signatory> getSignatores(){
        LinkedList<Signatory> signatories = new LinkedList<Signatory>();
        Signatory signatory0 = new Signatory();
        signatory0.setUserId("7D447E4A1BB14DEEE050007F01000F9E");
        signatory0.setLocation("192.168.114.66");
        signatory0.setSignLocation("Signature1");
        signatory0.setAuthorizationTime("20181121095509");
        signatories.add(signatory0);

        Signatory signatory1 = new Signatory();
        signatory1.setUserId("7D4713720B5634FEE050007F010014A8");
        signatory1.setLocation("beijing");
        signatory1.setSignLocation("Signature_plat");
        signatory1.setAuthorizationTime("20181121095509");
        signatories.add(signatory1);
        return signatories;

    }
    public static LinkedList<ContractDataItem> getContractDataItems(){
        LinkedList<ContractDataItem> contractDataItems = new LinkedList<ContractDataItem>();
        ContractDataItem contractDataItem0 = new ContractDataItem();
        contractDataItem0.setContractDataKey("1");
        contractDataItem0.setContractDataValue("北京市");
        contractDataItems.add(contractDataItem0);

        ContractDataItem contractDataItem1 = new ContractDataItem();
        contractDataItem1.setContractDataKey("2");
        contractDataItem1.setContractDataValue("12");
        contractDataItems.add(contractDataItem1);

        ContractDataItem contractDataItem2 = new ContractDataItem();
        contractDataItem2.setContractDataKey("3");
        contractDataItem2.setContractDataValue("5000");
        contractDataItems.add(contractDataItem2);
        return  contractDataItems;
    }
}
