create sequence app_im_message_s;
CREATE TABLE app_im_message (
  message_id number(20) NOT NULL,
  user_id varchar2(255) DEFAULT NULL,
  chat_id varchar2(255) DEFAULT NULL,
  host varchar2(255) DEFAULT NULL ,
  guest varchar2(255) DEFAULT NULL ,
  text varchar2(255)  DEFAULT NULL ,
  store_time datetime DEFAULT CURRENT_TIMESTAMP,
  OBJECT_VERSION_NUMBER number(11) DEFAULT NULL,
  CREATION_DATE datetime DEFAULT NULL,
  CREATED_BY varchar(255) DEFAULT NULL,
  LAST_UPDATE_DATE datetime DEFAULT NULL,
  LAST_UPDATED_BY number(11) DEFAULT NULL,
  request_id number(11) DEFAULT NULL,
  program_id number(11) DEFAULT NULL,
  LAST_UPDATE_LOGIN number(20) DEFAULT NULL,
);
-- Add comments to the table
comment on table app_im_message
  is 'app聊天记录表';
-- Add comments to the columns
comment on column app_im_message.message_id
  is '数据库自增唯一id';
comment on column app_im_message.user_id
  is '当前用户';
  comment on column app_im_message.chat_id
  is '聊天ID';
  comment on column app_im_message.host
  is '发送方';
  comment on column app_im_message.guest
  is '接收方';
  comment on column app_im_message.text
  is '消息内容';
-- Create/Recreate primary, unique and foreign key constraints
alter table app_im_message
  add constraint app_im_message_pk primary key (message_id)
  using index ;