DROP TABLE IF EXISTS app_im_message;
CREATE TABLE app_im_message (
  message_id bigint(20) NOT NULL AUTO_INCREMENT COMMENT '数据库自增唯一id',
  user_id varchar(255) DEFAULT NULL COMMENT '当前用户',
  chat_id varchar(255) DEFAULT NULL COMMENT '消息ID',
  host varchar(255) DEFAULT NULL COMMENT '发送方',
  guest varchar(255) DEFAULT NULL COMMENT '接收方',
  text varchar(255) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '消息内容',
  store_time datetime DEFAULT CURRENT_TIMESTAMP,
  OBJECT_VERSION_NUMBER int(11) DEFAULT NULL,
  CREATION_DATE datetime DEFAULT NULL COMMENT '对话创建时间',
  CREATED_BY varchar(255) DEFAULT NULL COMMENT '由哪位用户存入的',
  LAST_UPDATE_DATE datetime DEFAULT NULL,
  LAST_UPDATED_BY int(11) DEFAULT NULL,
  request_id int(11) DEFAULT NULL,
  program_id int(11) DEFAULT NULL,
  LAST_UPDATE_LOGIN bigint(20) DEFAULT NULL,
  PRIMARY KEY (message_id)
);