package hls.support.core.db


import com.hand.hap.liquibase.MigrationHelper

def mhi = MigrationHelper.getInstance()

databaseChangeLog(logicalFilePath:"hls/support/core/db/2019-01-14-init-table-migration.groovy"){

    changeSet(author: "jingchao", id: "20190114-face-card") {

        if(mhi.isDbType('oracle')){
            createSequence(sequenceName: 'face_card_s')
        }
        createTable(tableName: "face_card",remarks: '人证对比表') {
            column(name: "face_id", type: "VARCHAR(255)",remarks: '主键') {
                constraints(nullable: "false", primaryKey: "true")
            }
            column(name: "name", type:"VARCHAR(255)",remarks: '姓名')
            column(name: "id_number", type:"VARCHAR(255)",remarks: '身份证号码')
            if(mhi.isDbType('oracle')){
                column(name: "face_image", type:"CLOB",remarks: '人脸图片')
            }else{
                column(name: "face_image", type:"LONGTEXT",remarks: '人脸图片')
            }
            column(name: "code", type:"VARCHAR(10)")
            column(name: "message", type:"VARCHAR(100)")
            column(name: "res", type:"VARCHAR(100)")
            column(name: "description", type:"VARCHAR(100)")
            column(name: "score", type:"VARCHAR(100)")
            column(name: "object_version_number", type: "BIGINT", defaultValue : "1")
            column(name: "request_id", type: "BIGINT", defaultValue : "-1")
            column(name: "program_id", type: "BIGINT", defaultValue : "-1")
            column(name: "created_by", type: "BIGINT", defaultValue : "-1")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT", defaultValue : "-1")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_update_login", type: "BIGINT", defaultValue : "-1")
        }
    }
}
