package hls.support.core.db


import com.hand.hap.liquibase.MigrationHelper

def mhi = MigrationHelper.getInstance()

databaseChangeLog(logicalFilePath:"hls/support/core/db/2018-04-08-init-table-migration.groovy"){


    changeSet(author: "jingchao", id: "201806408-app-function") {

        if(mhi.isDbType('oracle')){
            createSequence(sequenceName: 'APP_FUNCTION_S')
        }
        createTable(tableName: "APP_FUNCTION",remarks: 'APP功能表') {
            column(autoIncrement: "true", name: "function_id", type: "BIGINT",remarks: '主键') {
                constraints(nullable: "false", primaryKey: "true")
            }
            column(name: "app_code", type:"VARCHAR(255)",remarks: 'APP代码'){
                constraints(nullable: "false")
            }
            column(name: "module_id", type:"BIGINT",remarks: '模块ID'){
                constraints(nullable: "false")
            }
            column(name: "function_name", type:"VARCHAR(255)",remarks: '功能名'){
                constraints(nullable: "false")
            }
            column(name: "function_code", type:"VARCHAR(255)",remarks: '功能代码'){
                constraints(nullable: "false")
            }
            column(name: "function_state", type:"VARCHAR(255)",remarks: '功能路由'){
                constraints(nullable: "false")
            }
            column(name: "function_icon", type:"VARCHAR(255)",remarks: '功能图标'){
                constraints(nullable: "false")
            }
            column(name: "enable_flag", type:"VARCHAR(255)",remarks: '启用标志',defaultValue : "Y")
            column(name: "prod_flag", type:"VARCHAR(255)",remarks: '使用标志',defaultValue : "Y")
            column(name: "function_type", type:"VARCHAR(255)",remarks: '功能类型')
            column(name: "target", type:"VARCHAR(255)")
            column(name: "object_version_number", type: "BIGINT", defaultValue : "1")
            column(name: "request_id", type: "BIGINT", defaultValue : "-1")
            column(name: "program_id", type: "BIGINT", defaultValue : "-1")
            column(name: "created_by", type: "BIGINT", defaultValue : "-1")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT", defaultValue : "-1")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_update_login", type: "BIGINT", defaultValue : "-1")
        }
    }
    changeSet(author: "jingchao", id: "201806408-app-function-exclude") {

        if(mhi.isDbType('oracle')){
            createSequence(sequenceName: 'APP_FUNCTION_EXCLUDE_S')
        }
        createTable(tableName: "APP_FUNCTION_EXCLUDE",remarks: '角色功能排除表') {
            column(autoIncrement: "true", name: "exclued_id", type: "BIGINT",remarks: '主键') {
                constraints(nullable: "false", primaryKey: "true")
            }
            column(name: "role_id", type:"BIGINT",remarks: '角色ID'){
                constraints(nullable: "false")
            }
            column(name: "function_id", type:"BIGINT",remarks: '功能ID'){
                constraints(nullable: "false")
            }
            column(name: "object_version_number", type: "BIGINT", defaultValue : "1")
            column(name: "request_id", type: "BIGINT", defaultValue : "-1")
            column(name: "program_id", type: "BIGINT", defaultValue : "-1")
            column(name: "created_by", type: "BIGINT", defaultValue : "-1")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT", defaultValue : "-1")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_update_login", type: "BIGINT", defaultValue : "-1")
        }
    }
    changeSet(author: "jingchao", id: "201806408-app-module") {

        if(mhi.isDbType('oracle')){
            createSequence(sequenceName: 'APP_MODULE_S')
        }
        createTable(tableName: "APP_MODULE",remarks: 'APP模块表') {
            column(autoIncrement: "true", name: "module_id", type: "BIGINT",remarks: '模块ID') {
                constraints(nullable: "false", primaryKey: "true")
            }
            column(name: "app_code", type:"VARCHAR(255)",remarks: 'APP代码'){
                constraints(nullable: "false")
            }
            column(name: "module_code", type:"VARCHAR(255)",remarks: '模块代码'){
                constraints(nullable: "false")
            }
            column(name: "module_name", type:"VARCHAR(255)",remarks: '模块名称'){
                constraints(nullable: "false")
            }
            column(name: "module_icon", type:"VARCHAR(255)",remarks: '模块图标'){
                constraints(nullable: "false")
            }
            column(name: "enable_flag", type:"VARCHAR(255)",remarks: '启用标志',defaultValue : "Y")
			column(name: "version", type:"BIGINT",remarks: '版本标志',defaultValue : "1")
            column(name: "object_version_number", type: "BIGINT", defaultValue : "1")
            column(name: "request_id", type: "BIGINT", defaultValue : "-1")
            column(name: "program_id", type: "BIGINT", defaultValue : "-1")
            column(name: "created_by", type: "BIGINT", defaultValue : "-1")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT", defaultValue : "-1")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_update_login", type: "BIGINT", defaultValue : "-1")
        }
    }
    changeSet(author: "jingchao", id: "201806408-app-role") {

        if(mhi.isDbType('oracle')){
            createSequence(sequenceName: 'APP_ROLE_S')
        }
        createTable(tableName: "APP_ROLE",remarks: 'APP角色表') {
            column(autoIncrement: "true", name: "role_id", type: "BIGINT",remarks: '角色ID') {
                constraints(nullable: "false", primaryKey: "true")
            }
            column(name: "app_code", type:"VARCHAR(255)",remarks: 'APP代码'){
                constraints(nullable: "false")
            }
            column(name: "role_code", type:"VARCHAR(255)",remarks: '角色代码'){
                constraints(nullable: "false")
            }
            column(name: "role_name", type:"VARCHAR(255)",remarks: '角色名称'){
                constraints(nullable: "false")
            }
            column(name: "enable_flag", type:"VARCHAR(255)",remarks: '启用标志',defaultValue : "Y")

            column(name: "object_version_number", type: "BIGINT", defaultValue : "1")
            column(name: "request_id", type: "BIGINT", defaultValue : "-1")
            column(name: "program_id", type: "BIGINT", defaultValue : "-1")
            column(name: "created_by", type: "BIGINT", defaultValue : "-1")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT", defaultValue : "-1")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_update_login", type: "BIGINT", defaultValue : "-1")
        }
    }
    changeSet(author: "jingchao", id: "201806408-app-role-module") {

        if(mhi.isDbType('oracle')){
            createSequence(sequenceName: 'APP_ROLE_MODULE_S')
        }
        createTable(tableName: "APP_ROLE_MODULE",remarks: '角色分配模块表') {
            column(autoIncrement: "true", name: "role_module_id", type: "BIGINT",remarks: '主键') {
                constraints(nullable: "false", primaryKey: "true")
            }
            column(name: "role_id", type:"BIGINT",remarks: '角色ID'){
                constraints(nullable: "false")
            }
            column(name: "module_id", type:"BIGINT",remarks: '模块ID'){
                constraints(nullable: "false")
            }
            column(name: "home_flag", type:"VARCHAR(255)",remarks: '主页标志'){
                constraints(nullable: "false")
            }
            column(name: "enable_flag", type:"VARCHAR(255)",remarks: '启用标志',defaultValue : "Y")
            column(name: "version", type:"BIGINT",remarks: '版本标志',defaultValue : "1")
            column(name: "object_version_number", type: "BIGINT", defaultValue : "1")
            column(name: "request_id", type: "BIGINT", defaultValue : "-1")
            column(name: "program_id", type: "BIGINT", defaultValue : "-1")
            column(name: "created_by", type: "BIGINT", defaultValue : "-1")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT", defaultValue : "-1")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_update_login", type: "BIGINT", defaultValue : "-1")
        }
    }

    changeSet(author: "jingchao", id: "201806408-app-home-picture") {

        if(mhi.isDbType('oracle')){
            createSequence(sequenceName: 'APP_HOME_PICTURE_S')
        }
        createTable(tableName: "app_home_picture",remarks: '首页轮播图') {
            column(autoIncrement: "true", name: "picture_id", type: "BIGINT",remarks: '主键') {
                constraints(nullable: "false", primaryKey: "true")
            }
            column(name: "app_code", type:"VARCHAR(255)",remarks: 'APP代码'){
                constraints(nullable: "false")
            }
            column(name: "picture_url", type:"VARCHAR(255)",remarks: '图片url'){
                constraints(nullable: "false")
            }
            column(name: "picture_sequence", type:"BIGINT",remarks: '顺序'){
                constraints(nullable: "false")
            }
            column(name: "remark", type:"VARCHAR(255)",remarks: '图片标题')
            column(name: "redirect_url", type:"VARCHAR(255)",remarks: '重定向地址')
            column(name: "enable_flag", type:"VARCHAR(255)",remarks: '启用标标志')
            column(name: "object_version_number", type: "BIGINT", defaultValue : "1")
            column(name: "request_id", type: "BIGINT", defaultValue : "-1")
            column(name: "program_id", type: "BIGINT", defaultValue : "-1")
            column(name: "created_by", type: "BIGINT", defaultValue : "-1")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT", defaultValue : "-1")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_update_login", type: "BIGINT", defaultValue : "-1")
        }
    }
}
