import Vue from 'vue'
import Router from 'vue-router'
import Home from '@/pages/home'
import ModuleFunction from '@/pages/homeManager/module-function'
// test工具类
import HlsPopup from '@/pages/hlsPopup'

// 合同
import ContractMaintenList from '@/pages/applications/contractMainten/contract-mainten-list'
import ContractMainten from '@/pages/applications/contractMainten/contract-mainten'
import ContractSignList from '@/pages/applications/contractSign/contract-sign-list'
import ContractSign from '@/pages/applications/contractSign/contract-sign'
import EsignPicture from '@/pages/applications/contractSign/esignPicture'

// 电子签章
import Esign from '@/pages/applications/esign/Esign'
import BankVerified from '@/pages/applications/esign/BankVerified'
import PersonAccount from '@/pages/applications/esign/PersonAccount'
import SignPdf from '@/pages/applications/esign/SignPdf'
import ViewPicture from '@/pages/applications/esign/ViewPicture'

// 用户注册
import UserRegister from '@/pages/applications/userRegisters/userRegister'
// 企业注册
import CompanyRegister from '@/pages/applications/userRegisters/companyRegister'
import ReadonlyCompanyReg from '@/pages/applications/userRegisters/readonlyCompanyReg'
// 授权经办人
import AuthorizedAgent from '@/pages/applications/userRegisters/authorizedAgent'

// 个人注册
import PersonalRegister from '@/pages/applications/userRegisters/personalRegister'
import ReadonlyPersonalReg from '@/pages/applications/userRegisters/readonlyPersonalReg'

// 电子签约
import ElectronicContract from '@/pages/applications/electronicContract/electronicContract'
import ElectronicContractList from '@/pages/applications/electronicContract/electronicContractList'
// 电子合同下载
import ContractDownload from '@/pages/applications/contractDownload/contractDownload'
import ContractDownloadList from '@/pages/applications/contractDownload/contractDownloadList'
// 图片上传微信服务器
import UploadImg from '@/pages/applications/userRegisters/uploadImg'
import UploadImage from '@/pages/applications/userRegisters/uploadImage'
// 银联电子签约
import ChinaUnionPay from '@/pages/applications/chinaUnionPay/chinaUnionPay'
// 招行聚合支付
import CmbPolyPay from '@/pages/applications/cmbPolyPay/cmbPolyPay'
// 招行聚合支付明细
import CmbPolyPayDetail from '@/pages/applications/cmbPolyPay/cmbPolyPayDetail'

Vue.use(Router)
// 全局跳转路由方法
Router.prototype.pushPage = function (param, bool) {
  debugger
  let key = true
  if (bool === undefined) {
    key = true
  } else if (bool === true || bool === false) {
    key = bool
  }
  this.currentRoute.meta.nextReload = key
  this.push(param)
}

export default new Router({
  routes: [{
    path: '/',
    redirect: to => {
      return { name: 'Home' }
    },
  },
  { path: '/home', component: Home, name: 'Home', meta: { keepAlive: false, nextReload: true } },
  { path: '/ModuleFunction', component: ModuleFunction, name: 'ModuleFunction', meta: { keepAlive: true } },
  // test工具类
  { path: '/hls-popup', component: HlsPopup, name: 'HlsPopup', meta: { keepAlive: false, nextReload: '' } },

  // 合同维护与签约
  {
    path: '/ContractMaintenList',
    component: ContractMaintenList,
    name: 'ContractMaintenList',
    meta: { keepAlive: false, nextReload: '' },
  },
  {
    path: '/ContractMainten',
    component: ContractMainten,
    name: 'ContractMainten',
    meta: { keepAlive: false, nextReload: '' },
  },
  {
    path: '/ContractSignList',
    component: ContractSignList,
    name: 'ContractSignList',
    meta: { keepAlive: false, nextReload: '' },
  },
  {
    path: '/ContractSign',
    component: ContractSign,
    name: 'ContractSign',
    meta: { keepAlive: false, nextReload: '' },
  },
  { path: '/EsignPicture', component: EsignPicture, name: 'EsignPicture', meta: { keepAlive: false } },
  { path: '/Esign', component: Esign, name: 'Esign', meta: { keepAlive: false } },
  { path: '/BankVerified', component: BankVerified, name: 'BankVerified', meta: { keepAlive: true } },
  { path: '/PersonAccount', component: PersonAccount, name: 'PersonAccount', meta: { keepAlive: true } },
  { path: '/SignPdf', component: SignPdf, name: 'SignPdf', meta: { keepAlive: true } },
  { path: '/ViewPicture', component: ViewPicture, name: 'ViewPicture', meta: { keepAlive: true } },
  {
    path: '/UserRegister',
    component: UserRegister,
    name: 'UserRegister',
    meta: {
      keepAlive: false,
    },
  },
  {
    path: '/UserRegister/PersonalRegister',
    component: PersonalRegister,
    name: 'PersonalRegister',
    meta: {
      keepAlive: false,
    },
  },
  {
    path: '/UserRegister/ReadonlyPersonalReg',
    component: ReadonlyPersonalReg,
    name: 'ReadonlyPersonalReg',
    meta: {
      keepAlive: true,
    },
  },

  {
    path: '/UserRegister/CompanyRegister',
    component: CompanyRegister,
    name: 'CompanyRegister',
    meta: {
      keepAlive: false,
    },
  },
  {
    path: '/UserRegister/ReadonlyCompanyReg',
    component: ReadonlyCompanyReg,
    name: 'ReadonlyCompanyReg',
    meta: {
      keepAlive: true,
    },
  },
  // 微信上传图片
  {
    path: '/UploadImg',
    component: UploadImg,
    name: 'UploadImg',
    meta: {
      keepAlive: true,
    },

  },
  {
    path: '/UploadImage',
    component: UploadImage,
    name: 'UploadImage',
    meta: {
      keepAlive: true,
    },
  },
  // 电子签约

  {
    path: '/ElectronicContract',
    component: ElectronicContract,
    name: 'ElectronicContract',
    meta: {
      keepAlive: false,
    },
  },
  {
    path: '/ElectronicContract/ElectronicContractList',
    component: ElectronicContractList,
    name: 'ElectronicContractList',
    meta: {
      keepAlive: true,
    },
  },
  // 电子合同下载
  {
    path: '/ContractDownload',
    component: ContractDownload,
    name: 'ContractDownload',
    meta: {
      keepAlive: false,
    },
  },
  // 电子合同下载
  {
    path: '/ContractDownload/ContractDownloadList',
    component: ContractDownloadList,
    name: 'ContractDownloadList',
    meta: {
      keepAlive: false,
    },
  },
  // 授权经办人
  {
    path: '/AuthorizedAgent',
    component: AuthorizedAgent,
    name: 'AuthorizedAgent',
    meta: {
      keepAlive: false,
    },
  },
  // 银联电子签约
  {
    path: '/ChinaUnionPay',
    component: ChinaUnionPay,
    name: 'ChinaUnionPay',
    meta: {
      keepAlive: false,
    },
  },
  // 招行聚合支付
  {
    path: '/CmbPolyPay',
    component: CmbPolyPay,
    name: 'CmbPolyPay',
    meta: {
      keepAlive: false,
    },
  },
  // 招行聚合支付合同明细
  {
    path: '/CmbPolyPayDetail',
    component: CmbPolyPayDetail,
    name: 'CmbPolyPayDetail',
    meta: {
      keepAlive: false,
    },
  },
  ],
  scrollBehavior (to, from, savedPosition) {
    if (to.hash) {
      return {
        selector: to.hash,
      }
    }
  },
})
